/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/ArraySet;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm"})
public final class ArraySet
extends IntrinsicMethod {
    public static final ArraySet INSTANCE;

    @Override
    @Nullable
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)codegen2, (String)"codegen");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        MaterialValue receiver = PromisedValueKt.getMaterialized((PromisedValue)irExpression.accept(codegen2, data));
        Type type2 = AsmUtil.correctElementType(receiver.getType());
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"AsmUtil.correctElementType(receiver.type)");
        Type elementType = type2;
        IrType elementIrType = IrUtilsKt.getArrayElementType(receiver.getIrType(), codegen2.getContext().getIrBuiltIns());
        IrExpression irExpression2 = expression2.getValueArgument(0);
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        ((PromisedValue)irExpression2.accept(codegen2, data)).materialize();
        IrExpression irExpression3 = expression2.getValueArgument(1);
        if (irExpression3 == null) {
            Intrinsics.throwNpe();
        }
        PromisedValueKt.coerce((PromisedValue)irExpression3.accept(codegen2, data), elementType, elementIrType).materialize();
        codegen2.getMv().astore(elementType);
        return PromisedValueKt.getImmaterialUnitValue(codegen2);
    }

    private ArraySet() {
    }

    static {
        ArraySet arraySet;
        INSTANCE = arraySet = new ArraySet();
    }
}

