/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;
    private final FunctionDescriptor functionDescriptor;
    private final Type receiverType;
    private final StackValue receiverValue;
    private final boolean isInliningStrategy;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state2, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall2, @Nullable Type receiverType, @Nullable StackValue receiverValue, boolean isInliningStrategy) {
        super(state2);
        this.resolvedCall = resolvedCall2;
        FunctionDescriptor referencedFunction = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (referencedFunction.isSuspend()) {
            this.referencedFunction = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(referencedFunction, state2);
            this.functionDescriptor = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, state2);
        } else {
            this.referencedFunction = referencedFunction;
            this.functionDescriptor = functionDescriptor;
        }
        this.receiverType = receiverType;
        this.receiverValue = receiverValue;
        this.isInliningStrategy = isInliningStrategy;
        assert (receiverType != null || receiverValue == null) : "A receiver value is provided for unbound function reference. Either this is a bound reference and you forgot to pass receiverType, or you accidentally passed some receiverValue for a reference without receiver";
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
        StackValue result2;
        final int receivers = CallableReferenceUtilKt.computeExpectedNumberOfReceivers(this.referencedFunction, this.receiverType != null);
        final int fakeArgCount = this.functionDescriptor.getValueParameters().size() - receivers;
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(this.state.getProject(), fakeArgCount);
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver2 = this.computeAndSaveReceiver(signature, codegen, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen, receivers);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(arg0);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>();
                int i = 0;
                for (ValueParameterDescriptor parameter : FunctionReferenceGenerationStrategy.this.referencedFunction.getValueParameters()) {
                    if (parameter.getVarargElementType() != null) {
                        if (i == fakeArgCount) {
                            this.argumentMap.put(parameter, ArgumentsUtilsKt.hasDefaultValue(parameter) ? DefaultValueArgument.DEFAULT : new VarargValueArgument());
                            continue;
                        }
                        if (FunctionReferenceGenerationStrategy.this.functionDescriptor.getValueParameters().get(receivers + i).getType().equals(parameter.getVarargElementType())) {
                            this.argumentMap.put(parameter, new VarargValueArgument(fakeArguments.subList(i, fakeArgCount)));
                            i = fakeArgCount;
                            continue;
                        }
                    }
                    if (i < fakeArgCount) {
                        this.argumentMap.put(parameter, new ExpressionValueArgument((ValueArgument)fakeArguments.get(i++)));
                        continue;
                    }
                    assert (ArgumentsUtilsKt.hasDefaultValue(parameter)) : "Parameter should be either vararg or expression or default: " + parameter + " (reference in: " + FunctionReferenceGenerationStrategy.access$100(FunctionReferenceGenerationStrategy.this).getContainingDeclaration() + ")";
                    this.argumentMap.put(parameter, DefaultValueArgument.DEFAULT);
                }
            }

            @Override
            @Nullable
            public ReceiverValue getExtensionReceiver() {
                return extensionReceiver2;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return dispatchReceiver;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.argumentMap;
            }

            @Override
            @NotNull
            public CallableDescriptor getCandidateDescriptor() {
                return FunctionReferenceGenerationStrategy.this.referencedFunction;
            }

            @Override
            @NotNull
            public CallableDescriptor getResultingDescriptor() {
                return FunctionReferenceGenerationStrategy.this.referencedFunction;
            }
        };
        Type returnType2 = codegen.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType2.getSort() == 9 ? codegen.generateNewArray(fakeExpression, this.referencedFunction.getReturnType(), fakeResolvedCall2) : codegen.generateConstructorCall(fakeResolvedCall2, returnType2);
        } else {
            Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
            result2 = codegen.invokeFunction(call2, fakeResolvedCall2, StackValue.none());
        }
        InstructionAdapter v2 = codegen.v;
        result2.put(returnType2, v2);
        v2.areturn(returnType2);
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen, int receivers) {
        List valueParameters2 = CollectionsKt.drop(this.functionDescriptor.getValueParameters(), (int)receivers);
        assert (valueParameters2.size() == fakeArguments.size()) : this.functionDescriptor + ": " + valueParameters2.size() + " != " + fakeArguments.size();
        for (int i = 0; i < valueParameters2.size(); ++i) {
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)valueParameters2.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen.myFrameMap.getIndex(parameter);
            if (localIndex > 0) {
                codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
                continue;
            }
            codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(parameter.getIndex() + 1 + receivers, type2));
        }
    }

    @Nullable
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen, @Nullable ReceiverParameterDescriptor receiver) {
        if (receiver == null) {
            return null;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createExpression("callableReferenceFakeReceiver");
        codegen.tempVariables.put(receiverExpression, this.receiverParameterStackValue(signature, codegen));
        return ExpressionReceiver.Companion.create(receiverExpression, receiver.getType(), BindingContext.EMPTY);
    }

    @NotNull
    private StackValue receiverParameterStackValue(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen) {
        if (this.receiverValue != null) {
            return this.receiverValue;
        }
        if (this.receiverType != null) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)codegen.getContext().getParentContext().getContextDescriptor();
            Type asmType = codegen.getState().getTypeMapper().mapClass(classDescriptor2);
            return CallableReferenceUtilKt.capturedBoundReferenceReceiver(asmType, this.receiverType, this.isInliningStrategy);
        }
        return StackValue.local(1, signature.getAsmMethod().getArgumentTypes()[0]);
    }
}

