/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u00a8\u0006\u000f"}, d2={"isJvmStaticFunction", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "makeJvmStaticFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "ownerClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "oldFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newName", "Lorg/jetbrains/kotlin/name/Name;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "isSynthetic", "backend"})
public final class JvmStaticAnnotationLoweringKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJvmStaticFunction(IrDeclaration declaration) {
        if (!(declaration instanceof IrSimpleFunction)) return false;
        if (IrUtilsKt.hasAnnotation(declaration, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return true;
        IrProperty irProperty = ((IrSimpleFunction)declaration).getCorrespondingProperty();
        if (irProperty == null) return false;
        if (!IrUtilsKt.hasAnnotation(irProperty, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrSimpleFunctionSymbol makeJvmStaticFunctionSymbol(IrClass ownerClass, IrFunctionSymbol oldFunctionSymbol, Name newName2, Visibility visibility, boolean isSynthetic) {
        Modality modality;
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        DeclarationDescriptor declarationDescriptor = ownerClass.getDescriptor();
        Annotations annotations2 = oldFunctionSymbol.getDescriptor().getAnnotations();
        SourceElement sourceElement = oldFunctionSymbol.getDescriptor().getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldFunctionSymbol.descriptor.source");
        JvmFunctionDescriptorImpl proxyDescriptorForIrFunction = new JvmFunctionDescriptorImpl(declarationDescriptor, null, annotations2, newName2, CallableMemberDescriptor.Kind.SYNTHESIZED, sourceElement, isSynthetic ? 4096 : 0);
        ReceiverParameterDescriptor receiverParameterDescriptor = oldFunctionSymbol.getDescriptor().getExtensionReceiverParameter();
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.copy(proxyDescriptorForIrFunction) : null;
        List<TypeParameterDescriptor> list2 = oldFunctionSymbol.getDescriptor().getTypeParameters();
        List<ValueParameterDescriptor> list3 = oldFunctionSymbol.getDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"oldFunctionSymbol.descriptor.valueParameters");
        Iterable iterable = list3;
        List<TypeParameterDescriptor> list4 = list2;
        ReceiverParameterDescriptor receiverParameterDescriptor3 = null;
        ReceiverParameterDescriptor receiverParameterDescriptor4 = receiverParameterDescriptor2;
        JvmFunctionDescriptorImpl jvmFunctionDescriptorImpl = proxyDescriptorForIrFunction;
        void var7_11 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            CallableDescriptor callableDescriptor = proxyDescriptorForIrFunction;
            void v8 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
            Name name = v8.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor, name, it.getIndex());
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        KotlinType kotlinType = oldFunctionSymbol.getDescriptor().getReturnType();
        if (IrUtilsKt.isInterface(ownerClass)) {
            modality = Modality.OPEN;
        } else {
            Modality modality2 = oldFunctionSymbol.getDescriptor().getModality();
            modality = modality2;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality2), (String)"oldFunctionSymbol.descriptor.modality");
        }
        jvmFunctionDescriptorImpl.initialize(receiverParameterDescriptor4, receiverParameterDescriptor3, list4, (List<ValueParameterDescriptor>)collection, kotlinType, modality, visibility);
        return new IrSimpleFunctionSymbolImpl(proxyDescriptorForIrFunction);
    }

    public static final /* synthetic */ boolean access$isJvmStaticFunction(@NotNull IrDeclaration declaration) {
        return JvmStaticAnnotationLoweringKt.isJvmStaticFunction(declaration);
    }

    @NotNull
    public static final /* synthetic */ IrSimpleFunctionSymbol access$makeJvmStaticFunctionSymbol(@NotNull IrClass ownerClass, @NotNull IrFunctionSymbol oldFunctionSymbol, @NotNull Name newName2, @NotNull Visibility visibility, boolean isSynthetic) {
        return JvmStaticAnnotationLoweringKt.makeJvmStaticFunctionSymbol(ownerClass, oldFunctionSymbol, newName2, visibility, isSynthetic);
    }
}

