/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<ContainingClass, FieldType> {
    private static final Unsafe unsafe = ReflectionUtil.getStaticFieldValue(Unsafe.class, Unsafe.class, "theUnsafe");
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        Unsafe unsafe = AtomicFieldUpdater.unsafe;
        if (unsafe == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(0);
        }
        return unsafe;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(1);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(2);
        }
        AtomicFieldUpdater<T, V> atomicFieldUpdater = new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
        if (atomicFieldUpdater == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(3);
        }
        return atomicFieldUpdater;
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(4);
        }
        AtomicFieldUpdater<T, Long> atomicFieldUpdater = new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
        if (atomicFieldUpdater == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(5);
        }
        return atomicFieldUpdater;
    }

    private AtomicFieldUpdater(@NotNull Class<ContainingClass> ownerClass, @NotNull Class<FieldType> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(8);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(9);
        }
        Field found = AtomicFieldUpdater.getTheOnlyVolatileFieldOfClass(ownerClass, fieldType);
        this.offset = unsafe.objectFieldOffset(found);
    }

    @NotNull
    private static <T, V> Field getTheOnlyVolatileFieldOfClass(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(10);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(11);
        }
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x18) != 0 || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        if (!BitUtil.isSet(found.getModifiers(), 64)) {
            throw new IllegalArgumentException("Field " + found + " in the " + ownerClass + " must be volatile");
        }
        Field field = found;
        if (field == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(12);
        }
        return field;
    }

    public boolean compareAndSet(@NotNull ContainingClass owner, FieldType expected, FieldType newValue) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(13);
        }
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull ContainingClass owner, long expected, long l) {
        void newValue;
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(14);
        }
        return unsafe.compareAndSwapLong(owner, this.offset, expected, (long)newValue);
    }

    static {
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forFieldOfType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forLongFieldIn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forIntFieldIn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyVolatileFieldOfClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forFieldOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forLongFieldIn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forIntFieldIn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyVolatileFieldOfClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSet";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetLong";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetInt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

