/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.cache.internal;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.cache.JdbiCache;
import org.jdbi.v3.core.cache.JdbiCacheLoader;
import org.jdbi.v3.core.cache.internal.DefaultJdbiCacheBuilder;
import org.jdbi.v3.core.cache.internal.DefaultJdbiCacheStats;
import org.jdbi.v3.core.cache.internal.DoubleLinkedList;

final class DefaultJdbiCache<K, V>
implements JdbiCache<K, V> {
    private final ConcurrentMap<K, DoubleLinkedList.Node<K, CompletableFuture<V>>> cache = new ConcurrentHashMap<K, DoubleLinkedList.Node<K, CompletableFuture<V>>>();
    @GuardedBy(value="expungeQueue")
    private final DoubleLinkedList<K, CompletableFuture<V>> expungeQueue = new DoubleLinkedList();
    private final JdbiCacheLoader<K, V> cacheLoader;
    private final int maxSize;

    DefaultJdbiCache(DefaultJdbiCacheBuilder builder, JdbiCacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
        this.maxSize = builder.getMaxSize();
    }

    @Override
    public V get(K key) {
        try {
            V v = this.doGet(key, this.cacheLoader);
            return v;
        }
        finally {
            this.expunge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getWithLoader(K key, JdbiCacheLoader<K, V> loader) {
        try {
            V v = this.doGet(key, loader);
            return v;
        }
        finally {
            this.expunge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doGet(K key, JdbiCacheLoader<K, V> loader) {
        DoubleLinkedList.Node node = this.cache.computeIfAbsent(key, k -> DoubleLinkedList.createNode(key, new CompletableFuture()));
        if (((CompletableFuture)node.value).isDone()) {
            if (!((CompletableFuture)node.value).isCompletedExceptionally()) {
                this.refresh(node);
            }
            return (V)((CompletableFuture)node.value).join();
        }
        DoubleLinkedList.Node node2 = node;
        synchronized (node2) {
            if (!((CompletableFuture)node.value).isDone()) {
                if (this.maxSize > 0) {
                    DoubleLinkedList<K, CompletableFuture<V>> doubleLinkedList = this.expungeQueue;
                    synchronized (doubleLinkedList) {
                        this.expungeQueue.addHead(node);
                    }
                }
                ((CompletableFuture)node.value).complete(loader == null ? null : (Object)loader.create(key));
            }
            return (V)((CompletableFuture)node.value).join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultJdbiCacheStats getStats() {
        DoubleLinkedList<K, CompletableFuture<V>> doubleLinkedList = this.expungeQueue;
        synchronized (doubleLinkedList) {
            return new DefaultJdbiCacheStats(this.expungeQueue.size, this.maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(DoubleLinkedList.Node<K, CompletableFuture<V>> node) {
        if (this.maxSize > 0) {
            DoubleLinkedList<K, CompletableFuture<V>> doubleLinkedList = this.expungeQueue;
            synchronized (doubleLinkedList) {
                DoubleLinkedList.Node<K, CompletableFuture<V>> cacheNode = this.expungeQueue.removeNode(node);
                if (cacheNode != null) {
                    this.expungeQueue.addHead(cacheNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expunge() {
        ArrayList purgeList = new ArrayList();
        DoubleLinkedList<K, CompletableFuture<V>> doubleLinkedList = this.expungeQueue;
        synchronized (doubleLinkedList) {
            if (this.maxSize <= 0 || this.expungeQueue.size <= this.maxSize) {
                return;
            }
            while (this.expungeQueue.size > this.maxSize) {
                DoubleLinkedList.Node<K, CompletableFuture<V>> node = this.expungeQueue.removeTail();
                if (node == null) continue;
                purgeList.add(node.key);
            }
        }
        purgeList.forEach(this.cache::remove);
    }
}

