/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.portlet;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;

public class PortletBodyRenderer
extends Renderer {
    private static BridgeLogger logger = new JULLoggerImpl(PortletBodyRenderer.class.getName());
    private static final String STYLE_CLASS = "styleClass";
    private static final String DIV = "div";
    private static final String PBR_STYLE_CLASS = "pbr-body";
    private static final Attribute[] BODY_ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.OUTPUTBODY);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        logger.log(BridgeLogger.Level.INFO, "encodeBegin()");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement(DIV, uiComponent);
        String portletClientId = facesContext.getViewRoot().getContainerClientId(facesContext);
        responseWriter.writeAttribute("id", (Object)portletClientId, "id");
        String styleClass = (String)uiComponent.getAttributes().get(STYLE_CLASS);
        if (null != styleClass && styleClass.length() != 0) {
            responseWriter.writeAttribute("class", (Object)(styleClass + " " + PBR_STYLE_CLASS), STYLE_CLASS);
        } else {
            responseWriter.writeAttribute("class", (Object)PBR_STYLE_CLASS, STYLE_CLASS);
        }
        RenderKitUtils.renderPassThruAttributes((FacesContext)facesContext, (ResponseWriter)responseWriter, (UIComponent)uiComponent, (Attribute[])BODY_ATTRIBUTES);
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List uiComponentResources = uiViewRoot.getComponentResources(facesContext, "body");
        if (null != uiComponentResources) {
            for (UIComponent uiComponentResource : uiComponentResources) {
                String originalTarget = (String)uiComponentResource.getAttributes().get("originalTarget");
                if (!"head".equals(originalTarget)) continue;
                uiComponentResource.encodeAll(facesContext);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List uiComponentResources = uiViewRoot.getComponentResources(facesContext, "body");
        if (null != uiComponentResources) {
            for (UIComponent uiComponentResource : uiComponentResources) {
                String originalTarget = (String)uiComponentResource.getAttributes().get("originalTarget");
                if ("head".equals(originalTarget)) continue;
                uiComponentResource.encodeAll(facesContext);
            }
        }
        RenderKitUtils.renderUnhandledMessages((FacesContext)facesContext);
        responseWriter.endElement(DIV);
    }
}

