/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PortalUrlQueryString {
    private static final String NULL = "";
    private Map<String, String[]> parameters;
    private boolean escape = false;

    public PortalUrlQueryString(String params) {
        this(params, false);
    }

    public PortalUrlQueryString(String params, boolean escape) {
        this.setQueryString(params);
        this.escape = escape;
    }

    protected String decodeURL(String par) {
        try {
            return URLDecoder.decode(par, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(par);
        }
    }

    protected String encodeURL(String par) {
        try {
            return URLEncoder.encode(par, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(par);
        }
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (null != values && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (null != values && values.length > 0) {
            ArrayList<String> valuesList = new ArrayList<String>(Arrays.asList(values));
            valuesList.add(value);
            values = valuesList.toArray(new String[valuesList.size()]);
        } else {
            values = new String[]{value};
        }
        this.parameters.put(name, values);
    }

    public String removeParameter(String name) {
        String[] values = this.parameters.remove(name);
        if (null != values && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public int parametersSize() {
        return this.parameters.size();
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setQueryString(String queryString) {
        this.parameters = new LinkedHashMap<String, String[]>(30);
        if (null != queryString && queryString.length() > 0) {
            queryString = queryString.replace("&amp;", "&");
            String[] queryParams = queryString.split("&");
            for (int i = 0; i < queryParams.length; ++i) {
                String par = queryParams[i];
                int eqIndex = par.indexOf(61);
                if (eqIndex >= 0) {
                    String value = par.substring(eqIndex + 1);
                    String name = par.substring(0, eqIndex);
                    this.addParameter(this.decodeURL(name), this.decodeURL(value));
                    continue;
                }
                this.addParameter(par, NULL);
            }
        }
    }

    public String toString() {
        if (null != this.parameters && this.parameters.size() > 0) {
            StringBuilder queryString = new StringBuilder();
            Iterator<Map.Entry<String, String[]>> iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String[]> param = iterator.next();
                String[] values = param.getValue();
                for (int i = 0; i < values.length; ++i) {
                    queryString.append(this.escape ? this.encodeURL(param.getKey()) : param.getKey());
                    if (values[i] != NULL) {
                        queryString.append('=').append(this.escape ? this.encodeURL(values[i]) : values[i]);
                    }
                    if (i >= values.length - 1) continue;
                    queryString.append('&');
                }
                if (!iterator.hasNext()) continue;
                queryString.append('&');
            }
            return queryString.toString();
        }
        return null;
    }
}

