/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.scope;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.faces.annotation.BridgePreDestroy;
import org.jboss.portletbridge.bridge.factory.BridgeLoggerFactoryImpl;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScope;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeUtil;
import org.jboss.portletbridge.listener.PortletBridgeListener;

public class BridgeRequestScopeImpl
extends ConcurrentHashMap<String, Object>
implements BridgeRequestScope {
    private static final long serialVersionUID = -5796085561862187555L;
    private static final BridgeLogger logger = BridgeLoggerFactoryImpl.getLogger(BridgeRequestScopeImpl.class.getName());
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private String uniqRequestScopeId;
    private String portletName;
    private String sessionId;
    private String viewId;
    private String portletMode;
    private Vector<String> excludedEntries;

    public BridgeRequestScopeImpl(String portletName, String sessionId, String viewId, String portletMode) {
        super(16, 0.75f, 4);
        this.initScope(portletName, sessionId, viewId, portletMode);
    }

    public BridgeRequestScopeImpl(String portletName, String sessionId, String viewId, String portletMode, int initialCapacity) {
        super(initialCapacity, 0.75f, 4);
        this.initScope(portletName, sessionId, viewId, portletMode);
    }

    public BridgeRequestScopeImpl(String portletName, String sessionId, String viewId, String portletMode, int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
        this.initScope(portletName, sessionId, viewId, portletMode);
    }

    public BridgeRequestScopeImpl(String portletName, String sessionId, String viewId, String portletMode, Map<String, Object> requestScopeDataMap) {
        super(16, 0.75f, 4);
        this.initScope(portletName, sessionId, viewId, portletMode);
        this.putAll((Map<? extends String, ? extends Object>)requestScopeDataMap);
    }

    private void initScope(String portletName, String sessionId, String viewId, String portletMode) {
        this.portletName = portletName;
        this.sessionId = sessionId;
        this.viewId = viewId;
        this.portletMode = portletMode;
    }

    public String getId() {
        if (null == this.uniqRequestScopeId) {
            long timeInMillis = Calendar.getInstance().getTimeInMillis();
            this.uniqRequestScopeId = new StringBuffer(BridgeRequestScopeUtil.generateBridgeRequestScopeIdPrefix(this.portletName, this.sessionId, this.viewId, this.portletMode)).append(':').append(Long.toString(timeInMillis)).toString();
        }
        return this.uniqRequestScopeId;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public void setExcludedEntries(List<String> excludedNames) {
        this.excludedEntries = new Vector<String>(excludedNames);
    }

    public void addExcludedEntries(List<String> excludedNames) {
        if (null != this.excludedEntries) {
            this.excludedEntries.addAll(excludedNames);
        } else {
            this.setExcludedEntries(excludedNames);
        }
    }

    public List<String> getExcludedEntries(List<String> excludedNames) {
        return this.excludedEntries;
    }

    public boolean isExcluded(String key, Object value) {
        return BridgeRequestScopeUtil.isExcluded(key, value, this.excludedEntries);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        if (!this.isExcluded(key, value)) {
            return this.callPreDestroy(key, super.putIfAbsent(key, value));
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (!this.isExcluded(key, value)) {
            return this.callPreDestroy(key, super.put(key, value));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(String key) {
        return this.callPreDestroy(key, super.remove(key));
    }

    public boolean remove(String key, Object value) {
        this.callPreDestroy(key, value);
        return super.remove(key, value);
    }

    @Override
    public Object replace(String key, Object value) {
        return this.callPreDestroy(key, super.replace(key, value));
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        if (!super.replace(key, oldValue, newValue)) {
            return false;
        }
        this.callPreDestroy(key, oldValue);
        return true;
    }

    @Override
    public void clear() {
        for (String key : this.keySet()) {
            this.callPreDestroy(key, this.get(key));
        }
        super.clear();
    }

    private Object callPreDestroy(String key, Object obj) {
        if (null != obj) {
            for (Method method : obj.getClass().getMethods()) {
                if (!method.isAnnotationPresent(BridgePreDestroy.class) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length > 0 || method.getReturnType() != Void.class) continue;
                try {
                    method.invoke(obj, new Object[]{null});
                }
                catch (Exception e) {
                    logger.log(BridgeLogger.Level.ERROR, "Error invoking @BridgePreDestroy method: " + method.getName() + " on: " + obj.getClass().getName(), (Throwable)e);
                }
            }
            PortletBridgeListener listener = PortletBridgeListener.getCurrentInstance();
            if (null != listener) {
                listener.handleAttributeEvent(key, obj);
            }
        }
        return obj;
    }
}

