/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="duplicateDependencyChecker")
public class DuplicateDependencyChecker
extends AbstractProjectChecker {
    @Override
    public String getCheckerDescription() {
        return "Checks if the POM has any duplicate dependency";
    }

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        HashSet<String> declaredManagedDependencies = new HashSet<String>();
        NodeList managedDependency = (NodeList)this.getxPath().evaluate("/project/dependencyManagement/dependencies/dependency/artifactId", doc, XPathConstants.NODESET);
        for (int x = 0; x < managedDependency.getLength(); ++x) {
            Node artifact = managedDependency.item(x);
            String artifactName = artifact.getTextContent();
            int lineNumber = this.getLineNumberFromNode(artifact);
            if (declaredManagedDependencies.add(artifactName)) continue;
            String msg = "Managed Dependency [%s] is declared more than once";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, artifactName));
        }
        HashSet<String> declaredDependencies = new HashSet<String>();
        NodeList dependencies = (NodeList)this.getxPath().evaluate("/project/dependencies/dependency/artifactId", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node artifact = dependencies.item(x);
            String artifactName = artifact.getTextContent();
            int lineNumber = this.getLineNumberFromNode(artifact);
            if (declaredDependencies.add(artifactName)) continue;
            String msg = "Dependency [%s] is declared more than once";
            this.addViolation(project.getFile(), results, lineNumber, String.format(msg, artifactName));
        }
    }
}

