/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.qstools.checkers;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.jboss.jdf.stacks.model.Bom;
import org.jboss.jdf.stacks.model.Stacks;
import org.jboss.maven.plugins.qstools.QSChecker;
import org.jboss.maven.plugins.qstools.Violation;
import org.jboss.maven.plugins.qstools.checkers.AbstractProjectChecker;
import org.jboss.maven.plugins.qstools.maven.MavenDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(role=QSChecker.class, hint="bomVersionChecker")
public class BomVersionChecker
extends AbstractProjectChecker {
    public static final String STACKS = "stacks";
    @Requirement
    private Context context;

    @Override
    public void processProject(MavenProject project, Document doc, Map<String, List<Violation>> results) throws Exception {
        NodeList dependencies = (NodeList)this.getxPath().evaluate("/project/dependencyManagement/dependencies/dependency", doc, XPathConstants.NODESET);
        for (int x = 0; x < dependencies.getLength(); ++x) {
            Node dependency = dependencies.item(x);
            MavenDependency mavenDependency = this.getDependencyProvider().getDependencyFromNode(project, dependency);
            Bom bomUsed = null;
            Stacks stacks = (Stacks)this.context.get((Object)STACKS);
            for (Bom bom : stacks.getAvailableBoms()) {
                if (!bom.getGroupId().equals(mavenDependency.getGroupId()) || !bom.getArtifactId().equals(mavenDependency.getArtifactId())) continue;
                bomUsed = bom;
            }
            int lineNumber = this.getLineNumberFromNode(dependency);
            if (bomUsed == null && !mavenDependency.getGroupId().startsWith("org.jboss")) {
                this.addViolation(project.getFile(), results, lineNumber, mavenDependency + " isn't a JBoss/JDF BOM");
                continue;
            }
            if (bomUsed == null || mavenDependency.getInterpoledVersion().equals(bomUsed.getRecommendedVersion())) continue;
            String violationMsg = String.format("BOM %s isn't using the recommended version %s", mavenDependency, bomUsed.getRecommendedVersion());
            this.addViolation(project.getFile(), results, lineNumber, violationMsg);
        }
    }

    @Override
    public String getCheckerDescription() {
        return "Check and verify if all quickstarts are using the recommended BOM version";
    }
}

