/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JBossAOPMojo
extends AbstractMojo {
    private boolean verbose;
    private boolean includeProjectDependency;
    private String classPath;
    private File[] aoppaths;
    private String aopClassPath;
    private String executable;
    private boolean loadtime;
    private Properties properties;
    private List<Artifact> pluginArtifacts;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeOutOfProcess(this.createCommandLine());
    }

    private void executeOutOfProcess(Commandline cl) {
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        try {
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
            this.processStream(new BufferedReader(new StringReader(err.getOutput())), true);
            this.processStream(new BufferedReader(new StringReader(out.getOutput())), false);
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
    }

    private Commandline createCommandLine() {
        String javaagent;
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        cl.setWorkingDirectory(this.project.getBuild().getOutputDirectory());
        if (this.loadtime && (javaagent = this.getJavaagentPath()) != null) {
            cl.addArguments(new String[]{"-javaagent:" + javaagent});
        }
        cl.addArguments(new String[]{"-cp", this.createClassPathList()});
        String aoppath = this.getAoppath();
        if (aoppath != null && aoppath.length() > 0) {
            cl.addArguments(new String[]{"-Djboss.aop.path=" + aoppath});
        }
        cl.addArguments(new String[]{"-Djboss.aop.verbose=" + Boolean.toString(this.verbose)});
        if (this.aopClassPath != null && this.aopClassPath.length() > 0) {
            cl.addArguments(new String[]{"-Djboss.aop.class.path=" + this.aopClassPath});
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            for (String string : this.properties.keySet()) {
                String value = this.properties.getProperty(string);
                if (string.startsWith("-D")) {
                    cl.addArguments(new String[]{string + "=" + value});
                    continue;
                }
                cl.addArguments(new String[]{"-D" + string + "=" + value});
            }
        }
        cl.addArguments(new String[]{this.executable});
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing aop: " + cl.toString()));
        }
        return cl;
    }

    private String getJavaagentPath() {
        for (Artifact a : this.pluginArtifacts) {
            if (!a.getArtifactId().equals("jboss-aop")) continue;
            return a.getFile().toString();
        }
        return null;
    }

    private String createClassPathList() {
        if (this.classPath != null && this.classPath.length() > 0) {
            return this.classPath;
        }
        StringBuffer sb = new StringBuffer();
        for (Artifact a : this.pluginArtifacts) {
            if (!a.getGroupId().startsWith("org.jboss") && !a.getGroupId().startsWith("jboss") && !a.getGroupId().startsWith("trove") && !a.getGroupId().startsWith("javassist")) continue;
            sb.append(a.getFile().toString()).append(File.pathSeparator);
        }
        if (this.includeProjectDependency) {
            for (Object o : this.project.getDependencyArtifacts()) {
                if (((Artifact)o).getFile() == null) continue;
                sb.append(((Artifact)o).getFile().toString()).append(File.pathSeparator);
            }
        }
        sb.append(this.project.getBuild().getOutputDirectory());
        return sb.toString();
    }

    private String getAoppath() {
        StringBuffer sb = new StringBuffer();
        if (this.aoppaths != null) {
            for (File aoppath : this.aoppaths) {
                if (aoppath == null) continue;
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(aoppath.getAbsolutePath());
            }
            return sb.toString();
        }
        return null;
    }

    private void processStream(BufferedReader input, boolean isError) {
        String err = null;
        try {
            while ((err = input.readLine()) != null) {
                if (isError) {
                    this.getLog().error((CharSequence)err);
                    continue;
                }
                this.getLog().info((CharSequence)err);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

