/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.Message;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class MessageIdValidator
implements ElementValidator {
    private final Map<String, Integer> messageIdMap = new HashMap<String, Integer>();

    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        for (ExecutableElement method : elementMethods) {
            Message message = method.getAnnotation(Message.class);
            if (message == null || message.id() <= 0 || !this.isIdAlreadyDefined(ElementHelper.getProjectCode(element), method, message)) continue;
            errorMessages.add(new ValidationErrorMessage(method, "Message id's must be unique for method " + method));
        }
        return errorMessages;
    }

    private boolean isIdAlreadyDefined(String projectCode, ExecutableElement method, Message message) {
        boolean alreadyDefined = false;
        String key = this.createKey(projectCode, message);
        int id = message.id();
        if (this.messageIdMap.containsKey(key)) {
            alreadyDefined = this.messageIdMap.get(key) == id;
        } else {
            this.messageIdMap.put(key, id);
        }
        return alreadyDefined;
    }

    private String createKey(String projectCode, Message message) {
        StringBuilder result = new StringBuilder();
        result.append(projectCode);
        result.append(":");
        result.append(message.id());
        return result.toString();
    }
}

