/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.logging;

/**
 * Defines a "pluggable" login module's logger implementation.
 *
 * @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>
 * @author David M. Lloyd
 * @version $Revision: 3403 $
 * @see org.jboss.logging.Logger
 * @see NullLoggerPluginInstance
 */
public interface LoggerPluginInstance {

    LoggerPlugin getLoggerPlugin();

    /**
     * Get the logger API instance associated with this plugin instance.
     *
     * @return the logger instance
     */
    Logger getLogger();

    /**
     * Determine whether logging is enabled for the given level.
     *
     * @param level the level
     * @return {@code false} if logging is disabled, or {@code true} if logging is enabled or cannot be ascertained
     */
    boolean isEnabled(Logger.Level level);

    /**
     * Log a message at the given level using messageformat formatting.
     *
     * @param level the level
     * @param loggerFqcn the fully qualified class name
     * @param message the message
     * @param params the message parameters or {@code null} if none
     * @param t the throwable cause or {@code null} if none
     */
    void log(Logger.Level level, String loggerFqcn, Object message, Object[] params, Throwable t);

    /**
     * Log a message at the given level using printf formatting.
     *
     * @param level the level
     * @param loggerFqcn the fully qualified class name
     * @param format the message format
     * @param params the message parameters or {@code null} if none
     * @param t the throwable cause or {@code null} if none
     */
    void logf(Logger.Level level, String loggerFqcn, String format, Object[] params, Throwable t);
}
