/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.templates;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
import org.jboss.profileservice.management.templates.JmsDestinationTemplateInfo;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JmsDestinationTemplate
implements DeploymentTemplate {
    private static final String FILE_SUFFIX = "-service.xml";
    protected static final String[] attributes = new String[]{"read", "write", "create"};
    private static final MetaValueFactory mvf = MetaValueFactoryBuilder.create();
    private DeploymentTemplateInfo info;

    public String getDeploymentName(String deploymentBaseName) {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null base name.");
        }
        if (!deploymentBaseName.endsWith(FILE_SUFFIX)) {
            deploymentBaseName = deploymentBaseName + FILE_SUFFIX;
        }
        return deploymentBaseName;
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        return this.applyTemplate(values);
    }

    public VirtualFile applyTemplate(DeploymentTemplateInfo values) throws Exception {
        File dsXml = File.createTempFile(this.getClass().getSimpleName(), FILE_SUFFIX);
        this.writeTemplate(dsXml, values);
        return VFS.getRoot((URI)dsXml.toURI());
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(File dsXml, DeploymentTemplateInfo info) throws Exception {
        if (info == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        if (info.getProperties() == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        ManagedProperty destTypeMP = (ManagedProperty)info.getProperties().get("destinationType");
        String destinationType = null;
        if (destTypeMP == null) {
            destinationType = ((JmsDestinationTemplateInfo)info).getDestinationType();
        } else {
            SimpleValue dsTypeSV = (SimpleValue)destTypeMP.getValue();
            destinationType = dsTypeSV.getValue().toString();
        }
        JmsDestinationMetaData destination = new JmsDestinationMetaData();
        String destinationName = (String)this.getProperty(info, "name");
        String jndiName = (String)this.getProperty(info, "JNDIName");
        if (jndiName == null) {
            throw new IllegalStateException("Null jndi name.");
        }
        if (destinationName == null) {
            destinationName = jndiName;
        }
        if ("QueueTemplate".equals(destinationType)) {
            destination.className = "org.jboss.jms.server.destination.QueueService";
            destination.xmbeanDd = "xmdesc/Queue-xmbean.xml";
            destination.jmxName = "jboss.messaging.destination:service=Queue,name=" + destinationName;
        } else if ("TopicTemplate".equals(destinationType)) {
            destination.className = "org.jboss.jms.server.destination.TopicService";
            destination.xmbeanDd = "xmdesc/Topic-xmbean.xml";
            destination.jmxName = "jboss.messaging.destination:service=Topic,name=" + destinationName;
        } else {
            throw new IllegalStateException("Unsupported destination type: " + destinationType);
        }
        ArrayList<JmsAttribute> attributes = new ArrayList<JmsAttribute>();
        destination.attribute = attributes;
        Map properties = info.getProperties();
        for (ManagedProperty p : properties.values()) {
            Element e;
            String n;
            boolean skip;
            MetaValue v = p.getValue();
            String name = p.getName();
            boolean bl = skip = !p.hasViewUse(ViewUse.CONFIGURATION) || p.isReadOnly() || p.isRemoved();
            if (skip && name.equals("clustered")) {
                skip = false;
            }
            if (skip || v == null || p == destTypeMP) continue;
            char c = name.charAt(0);
            if (Character.isLowerCase(c)) {
                name = Character.toUpperCase(c) + name.substring(1);
            }
            JmsAttribute attribute = null;
            if (v.getMetaType().isSimple()) {
                attribute = new JmsAttributeMetaData(name, "" + ((SimpleValue)v).getValue());
            } else if (name.equals("DLQ")) {
                n = (String)mvf.unwrap(v);
                attribute = new JmsAttributeMetaData("DLQ", n);
            } else if (name.equals("ExpiryQueue")) {
                n = (String)mvf.unwrap(v);
                attribute = new JmsAttributeMetaData("ExpiryQueue", n);
            } else if (name.equals("SecurityConfig") && (e = this.unwrapMetaValue((MapCompositeValueSupport)v)) != null) {
                attribute = new JmsElementMetaData("SecurityConfig", e);
            }
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList<JmsDependencyMetaData> depends = new ArrayList<JmsDependencyMetaData>();
        destination.depends = depends;
        String serverPeer = (String)this.getProperty(info, "serverPeer");
        if (serverPeer != null) {
            depends.add(new JmsDependencyMetaData("ServerPeer", serverPeer));
        } else {
            depends.add(new JmsDependencyMetaData("ServerPeer", "jboss.messaging:service=ServerPeer"));
        }
        depends.add(new JmsDependencyMetaData("jboss.messaging:service=PostOffice"));
        JmsDestinationDeployment deployment = new JmsDestinationDeployment();
        deployment.destination = destination;
        Class[] classes = new Class[]{JmsDestinationDeployment.class};
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXBElement root = new JAXBElement(new QName("server"), JmsDestinationDeployment.class, null, (Object)deployment);
        FileWriter fw = null;
        try {
            fw = new FileWriter(dsXml);
            marshaller.marshal((Object)root, (Writer)fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private Object getProperty(DeploymentTemplateInfo info, String propName) {
        Map propsInfo = info.getProperties();
        ManagedProperty prop = (ManagedProperty)propsInfo.get(propName);
        if (prop == null) {
            return null;
        }
        MetaValue value = prop.getValue();
        if (value instanceof MetaValue) {
            return mvf.unwrap(value);
        }
        return value;
    }

    protected Element unwrapMetaValue(MapCompositeValueSupport metaValue) {
        if (metaValue == null) {
            return null;
        }
        MapCompositeValueSupport value = metaValue;
        MapCompositeMetaType metaType = value.getMetaType();
        if (metaType.itemSet().isEmpty()) {
            return null;
        }
        Document d = JmsDestinationTemplate.createDocument();
        Element security = d.createElement("security");
        for (String name : metaType.itemSet()) {
            CompositeValue row = (CompositeValue)value.get(name);
            if (row == null) continue;
            Element role = d.createElement("role");
            role.setAttribute("name", name);
            for (String attribute : attributes) {
                SimpleValue v = (SimpleValue)row.get(attribute);
                if (v == null || v.getValue() == null) continue;
                role.setAttribute(attribute, ((Boolean)v.getValue()).toString());
            }
            security.appendChild(role);
        }
        return security;
    }

    protected static Document createDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface JmsAttribute {
    }

    public static class JmsDependencyMetaData {
        @XmlAttribute(name="optional-attribute-name")
        String attribute;
        @XmlValue
        String value;

        public JmsDependencyMetaData() {
        }

        public JmsDependencyMetaData(String value) {
            this.value = value;
        }

        public JmsDependencyMetaData(String attribute, String value) {
            this.attribute = attribute;
            this.value = value;
        }
    }

    public static class JmsElementMetaData
    implements JmsAttribute {
        @XmlAttribute
        String name;
        @XmlAnyElement
        Element value;

        public JmsElementMetaData() {
        }

        public JmsElementMetaData(String name, Element value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class JmsAttributeMetaData
    implements JmsAttribute {
        @XmlAttribute
        String name;
        @XmlValue
        String value;

        public JmsAttributeMetaData() {
        }

        public JmsAttributeMetaData(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class JmsDestinationMetaData {
        @XmlAttribute(name="code")
        String className;
        @XmlAttribute(name="name")
        String jmxName;
        @XmlAttribute(name="xmbean-dd")
        String xmbeanDd;
        @XmlElement
        String annotation;
        @XmlElements(value={@XmlElement(type=JmsAttributeMetaData.class), @XmlElement(type=JmsElementMetaData.class)})
        public List<JmsAttribute> attribute;
        public List<JmsDependencyMetaData> depends;
    }

    @XmlRootElement(name="server")
    public static class JmsDestinationDeployment {
        @XmlElement(name="mbean")
        public JmsDestinationMetaData destination;
    }
}

