/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.profileservice.management.ProxyDeploymentInfo;
import org.jboss.profileservice.spi.ManagedMBeanDeploymentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyManagedDeploymentFactory
implements ManagedMBeanDeploymentFactory {
    private String factoryName;
    private Set<ProxyDeploymentInfo> rootMOPatterns;
    private String defaultViewUse;

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public Set<ProxyDeploymentInfo> getRootMOPatterns() {
        return this.rootMOPatterns;
    }

    public void setRootMOPatterns(Set<ProxyDeploymentInfo> rootMOPatterns) {
        this.rootMOPatterns = rootMOPatterns;
    }

    @Override
    public String getDefaultViewUse() {
        return this.defaultViewUse;
    }

    public void setDefaultViewUse(String defaultViewUse) {
        this.defaultViewUse = defaultViewUse;
    }

    @Override
    public Collection<ManagedMBeanDeploymentFactory.MBeanDeployment> getDeployments(MBeanServer mbeanServer) {
        HashMap<String, ManagedMBeanDeploymentFactory.MBeanDeployment> tmp = new HashMap<String, ManagedMBeanDeploymentFactory.MBeanDeployment>();
        if (this.rootMOPatterns == null) {
            return tmp.values();
        }
        for (ProxyDeploymentInfo info : this.rootMOPatterns) {
            Set<ObjectName> names = mbeanServer.queryNames(info.getPattern(), null);
            if (names == null) continue;
            for (ObjectName name : names) {
                String dname = info.getNameBuilder().getName(name, mbeanServer);
                ManagedMBeanDeploymentFactory.MBeanDeployment deployment = (ManagedMBeanDeploymentFactory.MBeanDeployment)tmp.get(dname);
                if (deployment == null) {
                    deployment = new ManagedMBeanDeploymentFactory.MBeanDeployment(dname);
                    tmp.put(dname, deployment);
                }
                String compType = info.getCompType();
                String compSubtype = info.getCompSubtype();
                ManagedMBeanDeploymentFactory.MBeanComponent rootComp = new ManagedMBeanDeploymentFactory.MBeanComponent(name, compType, compSubtype);
                deployment.addComponent(rootComp);
                Map<String, String> componentInfo = info.getComponentInfo();
                if (componentInfo == null) continue;
                for (Map.Entry<String, String> comp : componentInfo.entrySet()) {
                    String compPropertyName = comp.getKey();
                    String compTypeInfo = comp.getValue();
                    try {
                        Object attribute = mbeanServer.getAttribute(name, compPropertyName);
                        String[] compTypeParts = compTypeInfo.split(":");
                        this.processComponents(attribute, compTypeParts[0], compTypeParts[1], deployment);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return tmp.values();
    }

    private void processComponents(Object attribute, String type, String subtype, ManagedMBeanDeploymentFactory.MBeanDeployment deployment) throws Exception {
        block4: {
            block5: {
                ObjectName[] names;
                block3: {
                    String[] names2;
                    if (!(attribute instanceof String[])) break block3;
                    for (String name : names2 = (String[])attribute) {
                        ObjectName compName = new ObjectName(name);
                        ManagedMBeanDeploymentFactory.MBeanComponent comp = new ManagedMBeanDeploymentFactory.MBeanComponent(compName, type, subtype);
                        deployment.addComponent(comp);
                    }
                    break block4;
                }
                if (!(attribute instanceof ObjectName[])) break block5;
                for (ObjectName compName : names = (ObjectName[])attribute) {
                    ManagedMBeanDeploymentFactory.MBeanComponent comp = new ManagedMBeanDeploymentFactory.MBeanComponent(compName, type, subtype);
                    deployment.addComponent(comp);
                }
                break block4;
            }
            if (!(attribute instanceof Collection)) break block4;
            Collection names = (Collection)attribute;
            for (Object name : names) {
                ManagedMBeanDeploymentFactory.MBeanComponent comp = null;
                ObjectName compName = null;
                compName = name instanceof ObjectName ? (ObjectName)name : new ObjectName(name.toString());
                comp = new ManagedMBeanDeploymentFactory.MBeanComponent(compName, type, subtype);
                deployment.addComponent(comp);
            }
        }
    }
}

