/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.modify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.vfs.plugins.structure.modify.AbstractModificationTypeMatcher;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileModificationTypeMatcher
extends AbstractModificationTypeMatcher {
    private String[] paths;
    private boolean metadataOnly;

    public FileModificationTypeMatcher(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Null or empty paths");
        }
        this.paths = paths;
    }

    @Override
    protected boolean isModificationDetermined(VirtualFile root, ContextInfo contextInfo) {
        for (String path : this.paths) {
            for (VirtualFile file : this.getStartingFiles(root, contextInfo)) {
                if (!file.getChild(path).exists()) continue;
                return true;
            }
        }
        return false;
    }

    protected List<VirtualFile> getStartingFiles(VirtualFile file, ContextInfo contextInfo) {
        if (this.metadataOnly) {
            List metadataPaths = contextInfo.getMetaDataPath();
            if (metadataPaths == null || metadataPaths.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(metadataPaths.size());
            for (MetaDataEntry metadataPath : metadataPaths) {
                VirtualFile child = file.getChild(metadataPath.getPath());
                if (!child.exists()) continue;
                result.add(child);
            }
            return result;
        }
        return Collections.singletonList(file);
    }

    public void setMetadataOnly(boolean metadataOnly) {
        this.metadataOnly = metadataOnly;
    }
}

