/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.plugins.classloader.HostNameCreator;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.id.GUID;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class InMemoryClassesDeployer
extends AbstractVFSRealDeployer {
    public static final String DYNAMIC_CLASS_URL_KEY = "DYNAMIC_CLASS_URL_KEY";
    public static final String DYNAMIC_CLASS_KEY = "DYNAMIC_CLASS_KEY";
    private static final String MOUNT_HANDLE_KEY = "MOUNT_HANDLE_KEY";
    private TempFileProvider tempFileProvider = TempFileProvider.create((String)"vfsinmemory", (ScheduledExecutorService)Executors.newScheduledThreadPool(2));
    private HostNameCreator hostNameCreator;

    public InMemoryClassesDeployer() throws IOException {
        this.setStage(DeploymentStages.DESCRIBE);
        this.setOutput(ClassLoadingMetaData.class);
        this.setTopLevelOnly(true);
    }

    protected String createHost(VFSDeploymentUnit unit) {
        return this.hostNameCreator != null ? this.hostNameCreator.createHostName(unit) : GUID.asString();
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        try {
            VirtualFile classes = VFS.getChild((String)this.createHost(unit));
            URL dynamicClassRoot = classes.toURL();
            Closeable closeable = VFS.mountTemp((VirtualFile)classes, (TempFileProvider)this.tempFileProvider);
            unit.addAttachment(MOUNT_HANDLE_KEY, (Object)closeable);
            unit.addAttachment(DYNAMIC_CLASS_KEY, (Object)classes);
            unit.addAttachment(DYNAMIC_CLASS_URL_KEY, (Object)dynamicClassRoot);
            unit.prependClassPath(new VirtualFile[]{classes});
            this.log.debug((Object)("Dynamic class root for " + unit.getName() + " is " + dynamicClassRoot));
        }
        catch (Exception e) {
            throw new DeploymentException("Error creating dynamic class root", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(VFSDeploymentUnit unit) {
        this.log.debug((Object)("Removing dynamic class root for " + unit.getName()));
        try {
            unit.removeAttachment(DYNAMIC_CLASS_URL_KEY, URL.class);
            VirtualFile classes = (VirtualFile)unit.removeAttachment(DYNAMIC_CLASS_KEY, VirtualFile.class);
            if (classes != null) {
                unit.removeClassPath(new VirtualFile[]{classes});
            }
        }
        finally {
            try {
                Closeable closeable = (Closeable)unit.removeAttachment(MOUNT_HANDLE_KEY, Closeable.class);
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Error deleting dynamic class root for " + unit.getName()), (Throwable)e);
            }
        }
    }

    public void setHostNameCreator(HostNameCreator hostNameCreator) {
        this.hostNameCreator = hostNameCreator;
    }

    public void setTempFileProvider(TempFileProvider tempFileProvider) {
        if (tempFileProvider == null) {
            throw new IllegalArgumentException("Null temp file provider.");
        }
        this.tempFileProvider = tempFileProvider;
    }
}

