/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.AttachmentsFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentContextVisitor;
import org.jboss.deployers.structure.spi.DeploymentMBean;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.structure.spi.helpers.ComponentDeploymentContextMBean;
import org.jboss.deployers.structure.spi.helpers.TrackingMutableAttachments;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDeploymentContext
implements DeploymentContext,
ComponentDeploymentContextMBean,
MBeanRegistration {
    private static final long serialVersionUID = -5105972679660633071L;
    protected Logger log = Logger.getLogger(this.getClass());
    private String name;
    private ObjectName objectName;
    private MBeanServer server;
    private Set<Object> controllerContextNames;
    private DeploymentUnit unit;
    private DeploymentContext parent;
    private List<DeploymentContext> components = new CopyOnWriteArrayList<DeploymentContext>();
    private transient MutableAttachments transientAttachments = new TrackingMutableAttachments(AttachmentsFactory.createMutableAttachments());
    private transient MutableAttachments transientManagedObjects = new TrackingMutableAttachments(AttachmentsFactory.createMutableAttachments());
    private ScopeKey scope;
    private ScopeKey mutableScope;

    public ComponentDeploymentContext() {
    }

    public ComponentDeploymentContext(String name, DeploymentContext parent) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            String name = this.getName();
            name = name.replace("\"", "&quot;");
            String temp = "jboss.deployment:id=\"" + name + "\",type=Component";
            try {
                this.objectName = new ObjectName(temp);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("Error creating object name: " + temp, e);
            }
        }
        return this.objectName;
    }

    @Override
    public Set<Object> getControllerContextNames() {
        return this.controllerContextNames != null ? Collections.unmodifiableSet(this.controllerContextNames) : null;
    }

    @Override
    public synchronized void addControllerContextName(Object name) {
        if (this.controllerContextNames == null) {
            this.controllerContextNames = new HashSet<Object>();
        }
        this.controllerContextNames.add(name);
    }

    @Override
    public synchronized void removeControllerContextName(Object name) {
        if (this.controllerContextNames != null) {
            this.controllerContextNames.remove(name);
            if (this.controllerContextNames.isEmpty()) {
                this.controllerContextNames = null;
            }
        } else {
            this.log.warn((Object)("Removing name on null names: " + name));
        }
    }

    @Override
    public String getSimpleName() {
        return this.parent.getSimpleName();
    }

    @Override
    public String getRelativePath() {
        return this.parent.getRelativePath();
    }

    @Override
    public int getRelativeOrder() {
        return 0;
    }

    @Override
    public void setRelativeOrder(int relativeOrder) {
    }

    @Override
    public Comparator<DeploymentContext> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<DeploymentContext> comparator) {
    }

    @Override
    public ScopeKey getScope() {
        if (this.scope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.scope = builder.getComponentScope(this);
        }
        return this.scope;
    }

    @Override
    public void setScope(ScopeKey scope) {
        this.scope = scope;
    }

    @Override
    public ScopeKey getMutableScope() {
        if (this.mutableScope == null) {
            ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
            this.mutableScope = builder.getMutableComponentScope(this);
        }
        return this.mutableScope;
    }

    @Override
    public void setMutableScope(ScopeKey mutableScope) {
        this.mutableScope = mutableScope;
    }

    @Override
    public MetaData getMetaData() {
        return AbstractDeploymentContext.getMetaData(this);
    }

    @Override
    public MutableMetaData getMutableMetaData() {
        return AbstractDeploymentContext.getMutableMetaData(this);
    }

    @Override
    public DeploymentState getState() {
        return this.parent.getState();
    }

    @Override
    public void setState(DeploymentState state) {
        this.parent.setState(state);
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        if (this.unit == null) {
            throw new IllegalStateException("Deployment unit has not been set");
        }
        return this.unit;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    public void setMetaDataPath(String path) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.parent.getClassLoader();
    }

    @Override
    public ObjectName getClassLoaderName() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null || !(classLoader instanceof RealClassLoader)) {
            return null;
        }
        return ((RealClassLoader)classLoader).getObjectName();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        return false;
    }

    @Override
    public void removeClassLoader() {
    }

    @Override
    public void removeClassLoader(ClassLoaderFactory factory) {
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public DeploymentContext getTopLevel() {
        return this.parent.getTopLevel();
    }

    @Override
    public ObjectName getTopLevelName() {
        DeploymentContext top = this.getTopLevel();
        if (top == null || !(top instanceof DeploymentMBean)) {
            return null;
        }
        return ((DeploymentMBean)((Object)top)).getObjectName();
    }

    @Override
    public DeploymentContext getParent() {
        return this.parent;
    }

    @Override
    public ObjectName getParentName() {
        DeploymentContext parent = this.getParent();
        if (parent == null || !(parent instanceof DeploymentMBean)) {
            return null;
        }
        return ((DeploymentMBean)((Object)parent)).getObjectName();
    }

    @Override
    public void setParent(DeploymentContext parent) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public List<DeploymentContext> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<ObjectName> getChildNames() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(DeploymentContext child) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean removeChild(DeploymentContext child) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public Deployment getDeployment() {
        return this.parent.getDeployment();
    }

    @Override
    public void setDeployment(Deployment deployment) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public List<DeploymentContext> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public List<ObjectName> getComponentNames() {
        List<DeploymentContext> components = this.getComponents();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        for (DeploymentContext component : components) {
            if (!(component instanceof DeploymentMBean)) continue;
            result.add(((DeploymentMBean)((Object)component)).getObjectName());
        }
        return result;
    }

    @Override
    public void addComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.components.add(component);
        if (this.server != null) {
            this.registerMBeans(component, true, true);
        }
    }

    @Override
    public boolean removeComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        boolean result = this.components.remove(component);
        if (this.server != null) {
            this.unregisterMBeans(component, true, true);
        }
        component.cleanup();
        return result;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        return this.parent.getResourceClassLoader();
    }

    @Override
    public DeploymentResourceLoader getResourceLoader() {
        return this.parent.getResourceLoader();
    }

    @Override
    public Object getControllerContextName() {
        return this.parent.getControllerContextName();
    }

    @Override
    public void setRequiredStage(DeploymentStage stage) {
        this.parent.setRequiredStage(stage);
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        return this.parent.getDependencyInfo();
    }

    @Override
    public String listAttachments(boolean detail) {
        HashSet<String> processed = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        result.append("<table>");
        result.append("<tr><th>Attachment</th><th>Created</th><th>Referenced</th>");
        if (detail) {
            result.append("<th>Contents</th>");
        }
        result.append("<tr><td>Predetermined</td></tr>");
        ComponentDeploymentContext.listAttachments(result, this.getPredeterminedManagedObjects(), detail, processed);
        result.append("<tr><td>Managed Objects</td></tr>");
        ComponentDeploymentContext.listAttachments(result, (Attachments)this.getTransientManagedObjects(), detail, processed);
        result.append("<tr><td>Transient</td></tr>");
        ComponentDeploymentContext.listAttachments(result, (Attachments)this.getTransientAttachments(), detail, processed);
        result.append("</table>");
        return result.toString();
    }

    protected static void listAttachments(StringBuilder builder, Attachments attachments, boolean detail, Set<String> processed) {
        TrackingMutableAttachments tracking = null;
        if (attachments instanceof TrackingMutableAttachments) {
            tracking = (TrackingMutableAttachments)attachments;
        }
        for (Map.Entry attachment : attachments.getAttachments().entrySet()) {
            Set<String> deployers;
            String name = (String)attachment.getKey();
            List referenced = Collections.emptyList();
            if (tracking != null && (deployers = tracking.getReferenced(name)) != null) {
                referenced = new ArrayList<String>(tracking.getReferenced(name));
            }
            for (int row = 0; row < 1 || row < referenced.size(); ++row) {
                builder.append("<tr>");
                if (row == 0) {
                    builder.append("<td>`--").append(name).append("</td>");
                    if (tracking != null) {
                        builder.append("<td>").append(tracking.getCreated(name)).append("</td>");
                    } else {
                        builder.append("<td/>");
                    }
                } else {
                    builder.append("<td/><td/>");
                }
                if (tracking != null && row < referenced.size()) {
                    builder.append("<td>").append((String)referenced.get(row)).append("</td>");
                } else {
                    builder.append("<td/>");
                }
                if (row == 0 && detail) {
                    builder.append("<td>").append(attachment.getValue()).append("</td>");
                }
                builder.append("</tr>");
            }
            builder.append("</tr>");
        }
    }

    @Override
    public void visit(DeploymentContextVisitor visitor) throws DeploymentException {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(this, visitor);
    }

    private void visit(DeploymentContext context, DeploymentContextVisitor visitor) throws DeploymentException {
        visitor.visit(context);
        try {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            DeploymentContext[] childContexts = children.toArray(new DeploymentContext[children.size()]);
            for (int i = 0; i < childContexts.length; ++i) {
                if (childContexts[i] == null) {
                    throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
                }
                try {
                    this.visit(childContexts[i], visitor);
                    continue;
                }
                catch (Throwable t) {
                    for (int j = i - 1; j >= 0; --j) {
                        this.visitError(childContexts[j], visitor, true);
                    }
                    throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + childContexts[i].getName()), (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            this.visitError(context, visitor, false);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error visiting: " + context.getName()), (Throwable)t);
        }
    }

    private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren) throws DeploymentException {
        if (visitChildren) {
            List<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            for (DeploymentContext child : children) {
                try {
                    this.visitError(child, visitor, true);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error during visit error: " + child.getName()), t);
                }
            }
        }
        try {
            visitor.error(context);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during visit error: " + context.getName()), t);
        }
    }

    public Attachments getPredeterminedManagedObjects() {
        return this.parent.getPredeterminedManagedObjects();
    }

    public void setPredeterminedManagedObjects(Attachments objects) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    public MutableAttachments getTransientManagedObjects() {
        return this.transientManagedObjects;
    }

    public MutableAttachments getTransientAttachments() {
        return this.transientAttachments;
    }

    @Override
    public Throwable getProblem() {
        return this.parent.getProblem();
    }

    @Override
    public void setProblem(Throwable problem) {
        this.parent.setProblem(problem);
    }

    @Override
    public void deployed() {
        this.parent.deployed();
    }

    @Override
    public boolean isDeployed() {
        return this.parent.isDeployed();
    }

    @Override
    public void cleanup() {
        AbstractDeploymentContext.cleanupRepository(this);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.registerMBeans(this, false, true);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.unregisterMBeans(this, false, true);
    }

    @Override
    public void postDeregister() {
    }

    protected void registerMBeans(DeploymentContext context, boolean registerContext, boolean registerSubDeployments) {
        if (registerContext && context instanceof DeploymentMBean) {
            try {
                DeploymentMBean depMBean = (DeploymentMBean)((Object)context);
                this.server.registerMBean(context, depMBean.getObjectName());
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to register deployment mbean " + context.getName()), (Throwable)e);
            }
        }
        if (registerSubDeployments) {
            List<DeploymentContext> components = context.getComponents();
            for (DeploymentContext component : components) {
                this.registerMBeans(component, false, false);
            }
        }
    }

    protected void unregisterMBeans(DeploymentContext context, boolean unregisterContext, boolean unregisterSubDeployments) {
        if (unregisterContext && context instanceof DeploymentMBean) {
            try {
                DeploymentMBean depMBean = (DeploymentMBean)((Object)context);
                this.server.unregisterMBean(depMBean.getObjectName());
            }
            catch (Exception e) {
                this.log.trace((Object)("Unable to unregister deployment mbean " + context.getName()), (Throwable)e);
            }
        }
        if (unregisterSubDeployments) {
            List<DeploymentContext> components = context.getComponents();
            for (DeploymentContext component : components) {
                this.unregisterMBeans(component, false, false);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('{').append(this.name).append('}');
        return buffer.toString();
    }
}

