/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.standalone;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.plugin.common.DeploymentExecutionException;
import org.jboss.as.plugin.common.DeploymentFailureException;
import org.jboss.as.plugin.common.Operations;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.dmr.ModelNode;

public class StandaloneDeployment
implements Deployment {
    private final File content;
    private final ModelControllerClient client;
    private final String name;
    private final Deployment.Type type;

    public StandaloneDeployment(ModelControllerClient client, File content, String name, Deployment.Type type) {
        this.content = content;
        this.client = client;
        this.name = name == null ? content.getName() : name;
        this.type = type;
    }

    public static StandaloneDeployment create(ModelControllerClient client, File content, String name, Deployment.Type type) {
        return new StandaloneDeployment(client, content, name, type);
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException {
        DeploymentPlanBuilder planBuilder = builder;
        switch (this.type) {
            case DEPLOY: {
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case REDEPLOY: {
                planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                break;
            }
            case UNDEPLOY: {
                planBuilder = builder.undeploy(this.name).remove(this.name);
                break;
            }
            case FORCE_DEPLOY: {
                if (this.exists()) {
                    planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                    break;
                }
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                if (this.exists()) {
                    planBuilder = builder.undeploy(this.name).remove(this.name);
                    break;
                }
                return null;
            }
        }
        return planBuilder.build();
    }

    @Override
    public Deployment.Status execute() throws DeploymentExecutionException, DeploymentFailureException {
        Deployment.Status resultStatus = Deployment.Status.SUCCESS;
        try {
            ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null && plan.getDeploymentActions().size() > 0) {
                ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)manager.execute(plan).get();
                for (DeploymentAction action : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            throw new DeploymentExecutionException("Deployment failed.", actionResult.getDeploymentException());
                        }
                        case NOT_EXECUTED: {
                            throw new DeploymentExecutionException("Deployment not executed.", actionResult.getDeploymentException());
                        }
                        case ROLLED_BACK: {
                            throw new DeploymentExecutionException("Deployment failed and was rolled back.", actionResult.getDeploymentException());
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            resultStatus = Deployment.Status.REQUIRES_RESTART;
                        }
                    }
                }
            }
        }
        catch (DeploymentExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentExecutionException(e, "Error executing %s", new Object[]{this.type});
        }
        return resultStatus;
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private boolean exists() {
        block4: {
            ModelNode op = Operations.createListDeploymentsOperation();
            try {
                ModelNode result = this.client.execute(op);
                String deploymentName = this.name;
                if (Operations.successful(result)) {
                    List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                    for (ModelNode n : deployments) {
                        if (!n.asString().equals(deploymentName)) continue;
                        return true;
                    }
                    break block4;
                }
                throw new IllegalStateException(Operations.getFailureDescription(result));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        return false;
    }
}

