/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.standalone;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.plugin.deployment.ConnectionInfo;
import org.jboss.as.plugin.deployment.Deployment;
import org.jboss.dmr.ModelNode;

public class StandaloneDeployment
implements Deployment {
    private final File content;
    private final ModelControllerClient client;
    private final String name;
    private final Deployment.Type type;

    public StandaloneDeployment(ConnectionInfo connectionInfo, File content, String name, Deployment.Type type) {
        this.content = content;
        this.client = ModelControllerClient.Factory.create((InetAddress)connectionInfo.getHostAddress(), (int)connectionInfo.getPort(), (CallbackHandler)connectionInfo.getCallbackHandler());
        this.name = name == null ? content.getName() : name;
        this.type = type;
    }

    public static StandaloneDeployment create(ConnectionInfo connectionInfo, File content, String name, Deployment.Type type) {
        return new StandaloneDeployment(connectionInfo, content, name, type);
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException {
        DeploymentPlanBuilder planBuilder = builder;
        switch (this.type) {
            case DEPLOY: {
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case REDEPLOY: {
                planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                break;
            }
            case UNDEPLOY: {
                planBuilder = builder.undeploy(this.name).remove(this.name);
                break;
            }
            case FORCE_DEPLOY: {
                if (this.exists()) {
                    planBuilder = builder.replace(this.name, this.content).redeploy(this.name);
                    break;
                }
                planBuilder = builder.add(this.name, this.content).andDeploy();
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                if (this.exists()) {
                    planBuilder = builder.undeploy(this.name).remove(this.name);
                    break;
                }
                return null;
            }
        }
        return planBuilder.build();
    }

    @Override
    public Deployment.Status execute() throws MojoExecutionException, MojoFailureException {
        Deployment.Status resultStatus = Deployment.Status.SUCCESS;
        try {
            ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null && plan.getDeploymentActions().size() > 0) {
                ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)manager.execute(plan).get();
                for (DeploymentAction action : plan.getDeploymentActions()) {
                    ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(action.getId());
                    ServerUpdateActionResult.Result result = actionResult.getResult();
                    switch (result) {
                        case FAILED: {
                            throw new MojoExecutionException("Deployment failed.", actionResult.getDeploymentException());
                        }
                        case NOT_EXECUTED: {
                            throw new MojoExecutionException("Deployment not executed.", actionResult.getDeploymentException());
                        }
                        case ROLLED_BACK: {
                            throw new MojoExecutionException("Deployment failed and was rolled back.", actionResult.getDeploymentException());
                        }
                        case CONFIGURATION_MODIFIED_REQUIRES_RESTART: {
                            resultStatus = Deployment.Status.REQUIRES_RESTART;
                        }
                    }
                }
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error executing %s", new Object[]{this.type}), e);
        }
        return resultStatus;
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private boolean exists() {
        block7: {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-children-names");
            op.get("child-type").set("deployment");
            try {
                ModelNode result = this.client.execute(op);
                String deploymentName = this.name;
                if (result.hasDefined("outcome")) {
                    if (result.get("outcome").asString().equals("success")) {
                        List deployments = result.hasDefined("result") ? result.get("result").asList() : Collections.emptyList();
                        for (ModelNode n : deployments) {
                            if (!n.asString().equals(deploymentName)) continue;
                            return true;
                        }
                    } else if (result.get("outcome").asString().equals("failed")) {
                        throw new IllegalStateException(String.format("A failure occurred when checking existing deployments. Error: %s", result.hasDefined("failure-description") ? result.get("failure-description").asString() : "Unknown"));
                    }
                    break block7;
                }
                throw new IllegalStateException(String.format("An unexpected response was found checking the deployment. Result: %s", result));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

