/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class OperatingSystemMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static OperatingSystemMXBeanAttributeHandler INSTANCE = new OperatingSystemMXBeanAttributeHandler();

    private OperatingSystemMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name) || PlatformMBeanConstants.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.OPERATING_SYSTEM_METRICS.contains(name))) {
                throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
            }
            OperatingSystemMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.OPERATING_SYSTEM_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.OPERATING_SYSTEM_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            store.set("java.lang:type=OperatingSystem");
        } else if ("name".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getName());
        } else if ("arch".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getArch());
        } else if ("version".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getVersion());
        } else if ("available-processors".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        } else if ("system-load-average".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        } else if (PlatformMBeanConstants.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.OPERATING_SYSTEM_METRICS.contains(name)) {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
        }
    }
}

