/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.PersistentBundlesComplete;
import org.jboss.osgi.framework.PersistentBundlesHandler;
import org.osgi.framework.Bundle;

public class PersistentBundlesIntegration
implements PersistentBundlesHandler {
    public static ServiceController<?> addService(ServiceTarget serviceTarget, InitialDeploymentTracker deploymentTracker) {
        PersistentBundlesIntegration service = new PersistentBundlesIntegration();
        ServiceBuilder builder = serviceTarget.addService(IntegrationServices.PERSISTENT_BUNDLES_HANDLER, (Service)service);
        builder.addDependencies(new ServiceName[]{IntegrationServices.AUTOINSTALL_COMPLETE, InitialDeploymentTracker.INITIAL_DEPLOYMENTS_COMPLETE});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    private PersistentBundlesIntegration() {
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public PersistentBundlesIntegration getValue() {
        return this;
    }

    public static class InitialDeploymentTracker {
        static final ServiceName INITIAL_DEPLOYMENTS_COMPLETE = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"initial", "deployments", "COMPLETE"});
        private final Set<ServiceName> bundleInstallServices = new HashSet<ServiceName>();
        private final AtomicBoolean deploymentInstallComplete = new AtomicBoolean(false);
        private final AtomicInteger deploymentCount;
        private final Set<String> deploymentNames;
        private ServiceListener<Bundle> bundleInstallListener;

        public InitialDeploymentTracker(OperationContext context, SubsystemState.Activation activationMode) {
            ServiceTarget serviceTarget = context.getServiceTarget();
            PersistentBundlesComplete installComplete = new PersistentBundlesComplete(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected boolean allServicesAdded(Set<ServiceName> trackedServices) {
                    Set set = InitialDeploymentTracker.this.bundleInstallServices;
                    synchronized (set) {
                        return InitialDeploymentTracker.this.deploymentInstallComplete.get() && InitialDeploymentTracker.this.bundleInstallServices.size() == trackedServices.size();
                    }
                }
            };
            ServiceBuilder installCompleteBuilder = installComplete.install(serviceTarget);
            installCompleteBuilder.setInitialMode(activationMode == SubsystemState.Activation.EAGER ? ServiceController.Mode.ACTIVE : ServiceController.Mode.ON_DEMAND);
            this.deploymentNames = this.getDeploymentNames(context);
            this.deploymentCount = new AtomicInteger(this.deploymentNames.size());
            if (this.deploymentCount.get() == 0) {
                this.initialDeploymentsComplete(serviceTarget);
                installCompleteBuilder.install();
                return;
            }
            final HashSet<ServiceName> depUnitPhaseServices = new HashSet<ServiceName>();
            for (String deploymentName : this.deploymentNames) {
                ServiceName serviceName = org.jboss.as.server.deployment.Services.deploymentUnitName((String)deploymentName);
                depUnitPhaseServices.add(serviceName.append(new String[]{Phase.INSTALL.toString()}));
            }
            ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
            ServiceContainer listenerTarget = serviceRegistry.getService(Services.JBOSS_SERVER_CONTROLLER).getServiceContainer();
            this.bundleInstallListener = installComplete.getListener();
            AbstractServiceListener<Object> listener = new AbstractServiceListener<Object>((ServiceTarget)listenerTarget, serviceTarget, installComplete){
                final /* synthetic */ ServiceTarget val$listenerTarget;
                final /* synthetic */ ServiceTarget val$serviceTarget;
                final /* synthetic */ PersistentBundlesComplete val$installComplete;
                {
                    this.val$listenerTarget = serviceTarget;
                    this.val$serviceTarget = serviceTarget2;
                    this.val$installComplete = persistentBundlesComplete;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                    if (!InitialDeploymentTracker.this.isClosed()) {
                        ServiceName serviceName = controller.getName();
                        Set set = depUnitPhaseServices;
                        synchronized (set) {
                            if (depUnitPhaseServices.contains(serviceName)) {
                                switch (transition) {
                                    case STARTING_to_UP: 
                                    case STARTING_to_START_FAILED: {
                                        depUnitPhaseServices.remove(serviceName);
                                        int remaining = InitialDeploymentTracker.this.deploymentCount.decrementAndGet();
                                        OSGiLogger.LOGGER.debugf("Initial deployment tracked: %s (remaining=%d)", serviceName.getCanonicalName(), remaining);
                                        if (InitialDeploymentTracker.this.deploymentCount.get() != 0) break;
                                        this.val$listenerTarget.removeListener((ServiceListener)this);
                                        InitialDeploymentTracker.this.initialDeploymentsComplete(this.val$serviceTarget);
                                        this.val$installComplete.checkAndComplete();
                                    }
                                }
                            }
                        }
                    }
                }
            };
            listenerTarget.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)listener);
        }

        public ServiceListener<Bundle> getBundleInstallListener() {
            return this.bundleInstallListener;
        }

        public boolean isClosed() {
            return this.deploymentCount.get() == 0;
        }

        public boolean hasDeploymentName(String depname) {
            return this.deploymentNames.contains(depname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerBundleInstallService(ServiceName serviceName) {
            Set<ServiceName> set = this.bundleInstallServices;
            synchronized (set) {
                OSGiLogger.LOGGER.tracef("Register bundle install service: %s", serviceName);
                this.bundleInstallServices.add(serviceName);
            }
        }

        private void initialDeploymentsComplete(ServiceTarget serviceTarget) {
            OSGiLogger.LOGGER.tracef("Initial deployments complete", new Object[0]);
            ServiceBuilder deploymentCompleteBuilder = serviceTarget.addService(INITIAL_DEPLOYMENTS_COMPLETE, (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    ServiceController controller = context.getController();
                    OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", controller.getName(), controller.getMode());
                }
            });
            this.deploymentInstallComplete.set(true);
            deploymentCompleteBuilder.install();
        }

        private Set<String> getDeploymentNames(OperationContext context) {
            HashSet<String> result = new HashSet<String>();
            ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            ModelNode depmodel = model.get("deployment");
            if (depmodel.isDefined()) {
                List deploymentNodes = depmodel.asList();
                for (ModelNode node : deploymentNodes) {
                    Property property = node.asProperty();
                    ModelNode enabled = property.getValue().get("enabled");
                    if (!enabled.isDefined() || !enabled.asBoolean()) continue;
                    result.add(property.getName());
                }
                OSGiLogger.LOGGER.tracef("Expecting initial deployments: %s", result);
            }
            return result;
        }
    }
}

