/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.PersistentBundlesIntegration;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.BundleManager;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.StorageStateProvider;
import org.osgi.framework.BundleException;

public class BundleInstallProcessor
implements DeploymentUnitProcessor {
    private AttachmentKey<ServiceName> BUNDLE_INSTALL_SERVICE = AttachmentKey.create(ServiceName.class);
    private final PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker;

    public BundleInstallProcessor(PersistentBundlesIntegration.InitialDeploymentTracker deploymentTracker) {
        this.deploymentTracker = deploymentTracker;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Deployment deployment = (Deployment)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
        if (deployment != null) {
            ServiceName serviceName;
            try {
                BundleManager bundleManager = (BundleManager)depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
                if (!this.deploymentTracker.isClosed() && this.deploymentTracker.hasDeploymentName(depUnit.getName())) {
                    this.restoreStorageState(phaseContext, deployment);
                    serviceName = bundleManager.installBundle(deployment, this.deploymentTracker.getBundleInstallListener());
                    this.deploymentTracker.registerBundleInstallService(serviceName);
                } else {
                    serviceName = bundleManager.installBundle(deployment, null);
                }
            }
            catch (BundleException ex) {
                throw new DeploymentUnitProcessingException((Throwable)ex);
            }
            phaseContext.addDeploymentDependency(serviceName, OSGiConstants.INSTALLED_BUNDLE_KEY);
            depUnit.putAttachment(this.BUNDLE_INSTALL_SERVICE, (Object)serviceName);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        ServiceController controller;
        ServiceName serviceName = (ServiceName)depUnit.getAttachment(this.BUNDLE_INSTALL_SERVICE);
        ServiceController serviceController = controller = serviceName != null ? depUnit.getServiceRegistry().getService(serviceName) : null;
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private void restoreStorageState(DeploymentPhaseContext phaseContext, Deployment deployment) {
        StorageStateProvider storageProvider = (StorageStateProvider)phaseContext.getServiceRegistry().getRequiredService(Services.STORAGE_STATE_PROVIDER).getValue();
        StorageState storageState = storageProvider.getByLocation(deployment.getLocation());
        if (storageState != null) {
            deployment.addAttachment(StorageState.class, (Object)storageState);
            deployment.setAutoStart(false);
        }
    }
}

