/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiDescriptionProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class OSGiFrameworkPropertyWrite
extends AbstractWriteAttributeHandler<Object> {
    static final OSGiFrameworkPropertyWrite INSTANCE = new OSGiFrameworkPropertyWrite();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiDescriptionProviders.getResourceBundle(locale);
            node.get("operation-name").set("write-attribute");
            node.get("description").set(resbundle.getString("framework.property.write"));
            node.get(new String[]{"request-properties", "value", "description"}).set(resbundle.getString("framework.property.value"));
            node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
            node.get(new String[]{"request-properties", "value", "required"}).set(true);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiFrameworkPropertyWrite() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer();
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Object> handbackHolder) throws OperationFailedException {
        String propName = operation.get("address").asObject().get("property").asString();
        String propValue = resolvedValue.asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.setProperty(propName, propValue);
        }
        return true;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
        String propName = operation.get("address").asObject().get("property").asString();
        String propValue = valueToRestore.asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.setProperty(propName, propValue);
        }
    }
}

