/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.framework.Services;
import org.osgi.service.startlevel.StartLevel;

abstract class StartLevelHandler
implements OperationStepHandler {
    static final StartLevelHandler READ_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(StartLevel sls, OperationContext context, ModelNode operation) {
            int sl = sls.getStartLevel();
            context.getResult().set(sl);
        }
    };
    static final StartLevelHandler WRITE_HANDLER = new StartLevelHandler(){

        @Override
        void invokeOperation(StartLevel sls, OperationContext context, ModelNode operation) {
            int targetStartLevel = operation.require("value").asInt();
            sls.setStartLevel(targetStartLevel);
        }
    };

    StartLevelHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServiceController svc = context.getServiceRegistry(false).getRequiredService(Services.START_LEVEL);
        if (svc == null || svc.getState() != ServiceController.State.UP) {
            context.getFailureDescription().set(OSGiMessages.MESSAGES.osgiSubsystemNotActive());
        } else {
            StartLevel sls = (StartLevel)svc.getValue();
            this.invokeOperation(sls, context, operation);
        }
        context.completeStep();
    }

    abstract void invokeOperation(StartLevel var1, OperationContext var2, ModelNode var3);
}

