/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class OSGiConfigurationAdd
extends AbstractAddStepHandler {
    static final OSGiConfigurationAdd INSTANCE = new OSGiConfigurationAdd();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = OSGiSubsystemProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("configuration.add"));
            node.get(new String[]{"request-properties", "entries", "description"}).set(resbundle.getString("configuration.entries"));
            node.get(new String[]{"request-properties", "entries", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "entries", "required"}).set(true);
            node.get(new String[]{"request-properties", "entries", "value-type"}).set(ModelType.PROPERTY);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private OSGiConfigurationAdd() {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER || context.getType() == OperationContext.Type.HOST;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("entries").set(operation.get("entries"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode entries = operation.get("entries");
        String pid = operation.get("address").asObject().get("configuration").asString();
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (String key : entries.keys()) {
            ((Dictionary)dictionary).put(key, entries.get(key).asString());
        }
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.putConfiguration(pid, dictionary);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        String pid = operation.get("address").asObject().get("configuration").asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.removeConfiguration(pid);
        }
    }
}

