/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public abstract class TypeConverter {
    private static final Pattern VAULT_PATTERN = Pattern.compile("\\$\\{VAULT::.*::.*::.*\\}");

    public abstract OpenType<?> getOpenType();

    public abstract Object fromModelNode(ModelNode var1);

    public abstract ModelNode toModelNode(Object var1);

    public abstract Object[] toArray(List<Object> var1);

    static OpenType<?> convertToMBeanType(ModelNode description) {
        return TypeConverter.getConverter(description.hasDefined("type") ? description.get("type") : null, description.hasDefined("value-type") ? description.get("value-type") : null).getOpenType();
    }

    static ModelNode toModelNode(ModelNode description, Object value) {
        ModelNode node = new ModelNode();
        if (value == null) {
            return node;
        }
        ModelNode typeNode = description.hasDefined("type") ? description.get("type") : null;
        return TypeConverter.getConverter(typeNode, description.hasDefined("value-type") ? description.get("value-type") : null).toModelNode(value);
    }

    static Object fromModelNode(ModelNode description, ModelNode value) {
        if (value == null || !value.isDefined()) {
            return null;
        }
        ModelNode typeNode = description.hasDefined("type") ? description.get("type") : null;
        ModelNode valueNode = description.hasDefined("value-type") ? description.get("value-type") : null;
        return TypeConverter.getConverter(typeNode, valueNode).fromModelNode(value);
    }

    public static ModelType getType(ModelNode typeNode) {
        if (typeNode == null) {
            return ModelType.UNDEFINED;
        }
        try {
            return ModelType.valueOf((String)typeNode.toString());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static TypeConverter getConverter(ModelNode typeNode, ModelNode valueTypeNode) {
        ModelType modelType = TypeConverter.getType(typeNode);
        if (modelType == null) {
            return new ComplexTypeConverter(typeNode);
        }
        switch (modelType) {
            case BIG_DECIMAL: {
                return BigDecimalTypeConverter.INSTANCE;
            }
            case BIG_INTEGER: {
                return BigIntegerTypeConverter.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanTypeConverter.INSTANCE;
            }
            case BYTES: {
                return BytesTypeConverter.INSTANCE;
            }
            case DOUBLE: {
                return DoubleTypeConverter.INSTANCE;
            }
            case EXPRESSION: {
                return ExpressionTypeConverter.INSTANCE;
            }
            case STRING: {
                return StringTypeConverter.INSTANCE;
            }
            case PROPERTY: {
                return PropertyTypeConverter.INSTANCE;
            }
            case INT: {
                return IntegerTypeConverter.INSTANCE;
            }
            case LONG: {
                return LongTypeConverter.INSTANCE;
            }
            case TYPE: {
                return ModelTypeTypeConverter.INSTANCE;
            }
            case OBJECT: {
                return new ObjectTypeConverter(valueTypeNode);
            }
            case LIST: {
                return new ListTypeConverter(valueTypeNode);
            }
            case UNDEFINED: {
                return UndefinedTypeConverter.INSTANCE;
            }
        }
        throw JmxMessages.MESSAGES.unknownType(modelType);
    }

    private static ModelNode nullNodeAsUndefined(ModelNode node) {
        if (node == null) {
            return new ModelNode();
        }
        return node;
    }

    protected ModelNode resolveSimpleType(ModelNode node) {
        if (node.getType() == ModelType.EXPRESSION) {
            return node.resolve();
        }
        return node;
    }

    private static class ComplexTypeConverter
    extends TypeConverter {
        final ModelNode typeNode;

        ComplexTypeConverter(ModelNode typeNode) {
            this.typeNode = TypeConverter.nullNodeAsUndefined(typeNode);
        }

        @Override
        public OpenType<?> getOpenType() {
            ArrayList<String> itemNames = new ArrayList<String>();
            ArrayList<String> itemDescriptions = new ArrayList<String>();
            ArrayList itemTypes = new ArrayList();
            if (!this.typeNode.isDefined() || this.typeNode.getType() == ModelType.STRING) {
                return SimpleType.STRING;
            }
            for (String name : this.typeNode.keys()) {
                ModelNode current = this.typeNode.get(name);
                itemNames.add(name);
                String description = null;
                if (!current.hasDefined("description")) {
                    description = "-";
                } else {
                    description = current.get("description").asString().trim();
                    if (description.length() == 0) {
                        description = "-";
                    }
                }
                itemDescriptions.add(ComplexTypeConverter.getDescription(current));
                itemTypes.add(ComplexTypeConverter.getConverter(current.get("type"), current.get("value-type")).getOpenType());
            }
            try {
                return new CompositeType("Complex type", "A complex type", itemNames.toArray(new String[itemNames.size()]), itemDescriptions.toArray(new String[itemDescriptions.size()]), itemTypes.toArray(new OpenType[itemTypes.size()]));
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }

        static String getDescription(ModelNode node) {
            if (!node.hasDefined("description")) {
                return "-";
            }
            String description = node.get("description").asString();
            if (description.trim().length() == 0) {
                return "-";
            }
            return description;
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            OpenType<?> openType = this.getOpenType();
            if (openType instanceof CompositeType) {
                CompositeType compositeType = (CompositeType)openType;
                HashMap<String, Object> items = new HashMap<String, Object>();
                for (String attrName : compositeType.keySet()) {
                    TypeConverter converter = ComplexTypeConverter.getConverter(this.typeNode.get(new String[]{attrName, "type"}), this.typeNode.get(new String[]{attrName, "value-type"}));
                    items.put(attrName, converter.fromModelNode(node.get(attrName)));
                }
                try {
                    return new CompositeDataSupport(compositeType, items);
                }
                catch (OpenDataException e) {
                    throw new RuntimeException(e);
                }
            }
            return node.toJSONString(false);
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            if (o instanceof CompositeData) {
                ModelNode node = new ModelNode();
                CompositeData composite = (CompositeData)o;
                for (String key : composite.getCompositeType().keySet()) {
                    if (!this.typeNode.hasDefined(key)) {
                        throw JmxMessages.MESSAGES.unknownValue(key);
                    }
                    ModelNode type = this.typeNode.get(key).get("type");
                    ModelNode valueType = this.typeNode.get(key).get("value-type");
                    TypeConverter converter = ComplexTypeConverter.getConverter(type, valueType);
                    node.get(key).set(converter.toModelNode(composite.get(key)));
                }
                return node;
            }
            return ModelNode.fromJSONString((String)((String)o));
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new CompositeData[list.size()]);
        }
    }

    private static class ListTypeConverter
    extends TypeConverter {
        final ModelNode valueTypeNode;

        ListTypeConverter(ModelNode valueTypeNode) {
            this.valueTypeNode = TypeConverter.nullNodeAsUndefined(valueTypeNode);
        }

        @Override
        public OpenType<?> getOpenType() {
            try {
                return ArrayType.getArrayType(ListTypeConverter.getConverter(this.valueTypeNode, null).getOpenType());
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            TypeConverter converter = ListTypeConverter.getConverter(this.valueTypeNode, null);
            for (ModelNode element : node.asList()) {
                list.add(converter.fromModelNode(element));
            }
            return converter.toArray(list);
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            ModelNode node = new ModelNode();
            TypeConverter converter = ListTypeConverter.getConverter(this.valueTypeNode, null);
            for (Object value : (Object[])o) {
                node.add(converter.toModelNode(value));
            }
            return node;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return null;
        }
    }

    private static class ObjectTypeConverter
    extends TypeConverter {
        final ModelNode valueTypeNode;
        final ModelType valueType;
        OpenType<?> openType;

        ObjectTypeConverter(ModelNode valueTypeNode) {
            this.valueTypeNode = TypeConverter.nullNodeAsUndefined(valueTypeNode);
            ModelType valueType = ObjectTypeConverter.getType(valueTypeNode);
            this.valueType = valueType == ModelType.UNDEFINED ? null : valueType;
        }

        @Override
        public OpenType<?> getOpenType() {
            if (this.openType != null) {
                return this.openType;
            }
            this.openType = ObjectTypeConverter.getConverter(this.valueTypeNode, null).getOpenType();
            if (this.openType instanceof CompositeType || !this.valueTypeNode.isDefined()) {
                return this.openType;
            }
            try {
                CompositeType rowType = new CompositeType("entry", "An entry", new String[]{"key", "value"}, new String[]{"The key", "The value"}, new OpenType[]{SimpleType.STRING, this.openType});
                this.openType = new TabularType("A map", "The map is indexed by 'key'", rowType, new String[]{"key"});
                return this.openType;
            }
            catch (OpenDataException e1) {
                throw new RuntimeException(e1);
            }
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            if (this.valueType != null) {
                return this.fromSimpleModelNode(node);
            }
            TypeConverter converter = ObjectTypeConverter.getConverter(this.valueTypeNode, null);
            return converter.fromModelNode(node);
        }

        Object fromSimpleModelNode(ModelNode node) {
            List properties;
            TabularType tabularType = (TabularType)this.getOpenType();
            TabularDataSupport tabularData = new TabularDataSupport(tabularType);
            HashMap<String, ModelNode> values = new HashMap<String, ModelNode>();
            List list = properties = node.isDefined() ? node.asPropertyList() : null;
            if (properties != null) {
                for (Property prop : properties) {
                    values.put(prop.getName(), prop.getValue());
                }
            }
            TypeConverter converter = TypeConverter.getConverter(this.valueTypeNode, null);
            for (Map.Entry prop : values.entrySet()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put("key", prop.getKey());
                rowData.put("value", converter.fromModelNode((ModelNode)prop.getValue()));
                try {
                    tabularData.put(new CompositeDataSupport(tabularType.getRowType(), rowData));
                }
                catch (OpenDataException e) {
                    throw new RuntimeException(e);
                }
            }
            return tabularData;
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            if (this.valueType == null) {
                return TypeConverter.getConverter(this.valueTypeNode, null).toModelNode(o);
            }
            ModelNode node = new ModelNode();
            TypeConverter converter = TypeConverter.getConverter(this.valueTypeNode, null);
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Map.Entry<String, Object> entry2 = this.convertTabularTypeEntryToMapEntry(entry);
                node.get(entry2.getKey()).set(converter.toModelNode(entry2.getValue()));
            }
            return node;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            if (this.getOpenType() == SimpleType.STRING) {
                return list.toArray(new String[list.size()]);
            }
            return list.toArray(new Object[list.size()]);
        }

        private Map.Entry<String, Object> convertTabularTypeEntryToMapEntry(final Map.Entry<?, Object> entry) {
            if (entry.getKey() instanceof List) {
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        List keyList = (List)entry.getKey();
                        if (keyList.size() != 1) {
                            throw JmxMessages.MESSAGES.invalidKey(keyList, entry);
                        }
                        return (String)keyList.get(0);
                    }

                    @Override
                    public Object getValue() {
                        return ((CompositeDataSupport)entry.getValue()).get("value");
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return entry.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class ModelTypeTypeConverter
    extends SimpleTypeConverter {
        static final ModelTypeTypeConverter INSTANCE = new ModelTypeTypeConverter();

        private ModelTypeTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return String.valueOf(node.asString());
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set(ModelType.valueOf((String)((String)o)));
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }
    }

    private static class LongTypeConverter
    extends SimpleTypeConverter {
        static final LongTypeConverter INSTANCE = new LongTypeConverter();

        private LongTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.LONG;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asLong();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set(((Long)o).longValue());
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new Long[list.size()]);
        }
    }

    private static class PropertyTypeConverter
    extends StringTypeConverter {
        static final ExpressionTypeConverter INSTANCE = new ExpressionTypeConverter();

        private PropertyTypeConverter() {
        }
    }

    private static class ExpressionTypeConverter
    extends StringTypeConverter {
        static final ExpressionTypeConverter INSTANCE = new ExpressionTypeConverter();

        private ExpressionTypeConverter() {
        }
    }

    private static class UndefinedTypeConverter
    extends SimpleTypeConverter {
        static final UndefinedTypeConverter INSTANCE = new UndefinedTypeConverter();

        private UndefinedTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.toJSONString(false);
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return ModelNode.fromJSONString((String)((String)o));
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }
    }

    private static class StringTypeConverter
    extends SimpleTypeConverter {
        static final StringTypeConverter INSTANCE = new StringTypeConverter();

        private StringTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asString();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set((String)o);
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }

        @Override
        ModelNode createPossibleExpression(String s) {
            return new ModelNode().setExpression(s);
        }
    }

    private static class IntegerTypeConverter
    extends SimpleTypeConverter {
        static final IntegerTypeConverter INSTANCE = new IntegerTypeConverter();

        private IntegerTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.INTEGER;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asInt();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set(((Integer)o).intValue());
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new Integer[list.size()]);
        }
    }

    private static class DoubleTypeConverter
    extends SimpleTypeConverter {
        static final DoubleTypeConverter INSTANCE = new DoubleTypeConverter();

        private DoubleTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.DOUBLE;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asDouble();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set(((Double)o).doubleValue());
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new Double[list.size()]);
        }
    }

    private static class BytesTypeConverter
    extends TypeConverter {
        static final BytesTypeConverter INSTANCE = new BytesTypeConverter();
        static final ArrayType<byte[]> ARRAY_TYPE = ArrayType.getPrimitiveArrayType(byte[].class);

        private BytesTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return ARRAY_TYPE;
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            return node.asBytes();
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            try {
                return new ModelNode().set((byte[])o);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray((T[])new byte[list.size()][]);
        }
    }

    private static class BooleanTypeConverter
    extends SimpleTypeConverter {
        static final BooleanTypeConverter INSTANCE = new BooleanTypeConverter();

        private BooleanTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.BOOLEAN;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asBoolean();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set(((Boolean)o).booleanValue());
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new Boolean[list.size()]);
        }
    }

    private static class BigIntegerTypeConverter
    extends SimpleTypeConverter {
        static final BigIntegerTypeConverter INSTANCE = new BigIntegerTypeConverter();

        private BigIntegerTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.BIGINTEGER;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asBigInteger();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set((BigInteger)o);
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new BigInteger[list.size()]);
        }
    }

    private static class BigDecimalTypeConverter
    extends SimpleTypeConverter {
        static final BigDecimalTypeConverter INSTANCE = new BigDecimalTypeConverter();

        private BigDecimalTypeConverter() {
        }

        @Override
        public OpenType<?> getOpenType() {
            return SimpleType.BIGDECIMAL;
        }

        @Override
        Object internalFromModelNode(ModelNode node) {
            return node.asBigDecimal();
        }

        @Override
        public ModelNode internalToModelNode(Object o) {
            return new ModelNode().set((BigDecimal)o);
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new BigDecimal[list.size()]);
        }
    }

    private static abstract class SimpleTypeConverter
    extends TypeConverter {
        private SimpleTypeConverter() {
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined() || node.asString().length() == 0) {
                return null;
            }
            if (node.getType() == ModelType.EXPRESSION && !VAULT_PATTERN.matcher(node.asString()).matches()) {
                return this.internalFromModelNode(node.resolve());
            }
            return this.internalFromModelNode(node);
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            boolean possibleExpression = false;
            if (o instanceof String) {
                possibleExpression = this.isPossibleExpression((String)o);
            }
            if (possibleExpression) {
                return this.createPossibleExpression((String)o);
            }
            try {
                return this.internalToModelNode(o);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e);
            }
        }

        abstract ModelNode internalToModelNode(Object var1);

        abstract Object internalFromModelNode(ModelNode var1);

        private boolean isPossibleExpression(String s) {
            int start = s.indexOf("${");
            return start != -1 && s.indexOf(125, start) != -1;
        }

        ModelNode createPossibleExpression(String s) {
            throw JmxMessages.MESSAGES.expressionCannotBeConvertedIntoTargeteType(this.getOpenType());
        }
    }
}

