/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Values;

public class ApplicationContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName applicationContextServiceName = ContextNames.contextServiceNameOfApplication((String)moduleDescription.getApplicationName());
        NamingStoreService contextService = new NamingStoreService();
        serviceTarget.addService(applicationContextServiceName, (Service)contextService).install();
        BinderService applicationNameBinder = new BinderService("AppName");
        serviceTarget.addService(applicationContextServiceName.append(new String[]{"AppName"}), (Service)applicationNameBinder).addDependency(applicationContextServiceName, ServiceBasedNamingStore.class, applicationNameBinder.getNamingStoreInjector()).addInjection(applicationNameBinder.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)moduleDescription.getApplicationName()))).install();
        deploymentUnit.putAttachment(Attachments.APPLICATION_CONTEXT_CONFIG, (Object)applicationContextServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

