/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.datasource.DataSourceTransactionProxyHandler;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyConfiguration;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Values;

public class DirectDataSourceInjectionSource
extends InjectionSource {
    public static final ServiceName JBOSS_TXN = ServiceName.JBOSS.append(new String[]{"txn"});
    public static final ServiceName JBOSS_TXN_TRANSACTION_MANAGER = JBOSS_TXN.append(new String[]{"TransactionManager"});
    public static final ServiceName JBOSS_TXN_SYNCHRONIZATION_REGISTRY = JBOSS_TXN.append(new String[]{"TransactionSynchronizationRegistry"});
    public static final String USER_PROP = "user";
    public static final String URL_PROP = "url";
    public static final String UPPERCASE_USER_PROP = "URL";
    public static final String TRANSACTIONAL_PROP = "transactional";
    public static final String SERVER_NAME_PROP = "serverName";
    public static final String PROPERTIES_PROP = "properties";
    public static final String PORT_NUMBER_PROP = "portNumber";
    public static final String PASSWORD_PROP = "password";
    public static final String MIN_POOL_SIZE_PROP = "minPoolSize";
    public static final String MAX_STATEMENTS_PROP = "maxStatements";
    public static final String MAX_IDLE_TIME_PROP = "maxIdleTime";
    public static final String LOGIN_TIMEOUT_PROP = "loginTimeout";
    public static final String ISOLATION_LEVEL_PROP = "isolationLevel";
    public static final String INITIAL_POOL_SIZE_PROP = "initialPoolSize";
    public static final String DESCRIPTION_PROP = "description";
    public static final String DATABASE_NAME_PROP = "databaseName";
    public static final String MAX_POOL_SIZE_PROP = "maxPoolSize";
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private String className;
    private String description;
    private String url;
    private String databaseName;
    private String serverName;
    private int portNumber = -1;
    private int loginTimeout = -1;
    private int isolationLevel = -1;
    private boolean transactional = true;
    private int initialPoolSize = -1;
    private int maxIdleTime = -1;
    private int maxPoolSize = -1;
    private int maxStatements = -1;
    private int minPoolSize = -1;
    private String user;
    private String password;
    private String[] properties;
    private static final AtomicInteger proxyNameCount = new AtomicInteger(0);

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        Module module = (Module)phaseContext.getDeploymentUnit().getAttachment(Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)phaseContext.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        try {
            Class clazz = module.getClassLoader().loadClass(this.className);
            ClassReflectionIndex classIndex = deploymentReflectionIndex.getClassIndex(clazz);
            Constructor ctor = classIndex.getConstructor((Class[])NO_CLASSES);
            if (ctor == null) {
                throw EeMessages.MESSAGES.defaultConstructorNotFound("@DataSourceDefinition", this.className);
            }
            Object object = ctor.newInstance(new Object[0]);
            this.setProperties(deploymentReflectionIndex, clazz, object);
            if (this.transactional) {
                ServiceController syncController = phaseContext.getServiceRegistry().getService(JBOSS_TXN_SYNCHRONIZATION_REGISTRY);
                ServiceController managerController = phaseContext.getServiceRegistry().getService(JBOSS_TXN_TRANSACTION_MANAGER);
                if (syncController == null || managerController == null) {
                    EeLogger.ROOT_LOGGER.transactionSubsystemNotAvailable(this.className);
                } else {
                    try {
                        TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)syncController.getValue();
                        TransactionManager transactionManager = (TransactionManager)managerController.getValue();
                        ProxyConfiguration proxyConfiguration = new ProxyConfiguration().setClassLoader((ClassLoader)module.getClassLoader()).setSuperClass(clazz).setProxyName(clazz.getName() + "$$DataSourceProxy" + proxyNameCount.incrementAndGet()).setProtectionDomain(clazz.getProtectionDomain());
                        ProxyFactory proxyFactory = new ProxyFactory(proxyConfiguration);
                        object = proxyFactory.newInstance((InvocationHandler)new DataSourceTransactionProxyHandler(object, transactionManager, transactionSynchronizationRegistry));
                    }
                    catch (Exception e) {
                        EeLogger.ROOT_LOGGER.cannotProxyTransactionalDatasource(e, this.className);
                    }
                }
            }
            injector.inject((Object)new ValueManagedReferenceFactory(Values.immediateValue(object)));
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void setProperties(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, Object object) {
        this.setProperty(deploymentReflectionIndex, clazz, object, DESCRIPTION_PROP, this.description);
        this.setProperty(deploymentReflectionIndex, clazz, object, URL_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, clazz, object, UPPERCASE_USER_PROP, this.url);
        this.setProperty(deploymentReflectionIndex, clazz, object, DATABASE_NAME_PROP, this.databaseName);
        this.setProperty(deploymentReflectionIndex, clazz, object, SERVER_NAME_PROP, this.serverName);
        this.setProperty(deploymentReflectionIndex, clazz, object, PORT_NUMBER_PROP, this.portNumber);
        this.setProperty(deploymentReflectionIndex, clazz, object, LOGIN_TIMEOUT_PROP, this.loginTimeout);
        this.setProperty(deploymentReflectionIndex, clazz, object, ISOLATION_LEVEL_PROP, this.isolationLevel);
        this.setProperty(deploymentReflectionIndex, clazz, object, TRANSACTIONAL_PROP, this.transactional);
        this.setProperty(deploymentReflectionIndex, clazz, object, INITIAL_POOL_SIZE_PROP, this.initialPoolSize);
        this.setProperty(deploymentReflectionIndex, clazz, object, MAX_IDLE_TIME_PROP, this.maxIdleTime);
        this.setProperty(deploymentReflectionIndex, clazz, object, MAX_POOL_SIZE_PROP, this.maxPoolSize);
        this.setProperty(deploymentReflectionIndex, clazz, object, MAX_STATEMENTS_PROP, this.maxStatements);
        this.setProperty(deploymentReflectionIndex, clazz, object, MIN_POOL_SIZE_PROP, this.minPoolSize);
        this.setProperty(deploymentReflectionIndex, clazz, object, USER_PROP, this.user);
        this.setProperty(deploymentReflectionIndex, clazz, object, PASSWORD_PROP, this.password);
        if (this.properties != null) {
            for (String property : this.properties) {
                int pos = property.indexOf(61);
                if (pos == -1 || pos == property.length() - 1) continue;
                this.setProperty(deploymentReflectionIndex, clazz, object, property.substring(0, pos), property.substring(pos + 1));
            }
        }
    }

    private void setProperty(DeploymentReflectionIndex deploymentReflectionIndex, Class<?> clazz, Object object, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && "".equals(value)) {
            return;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return;
        }
        StringBuilder builder = new StringBuilder("set").append(name);
        builder.setCharAt(3, Character.toUpperCase(name.charAt(0)));
        String methodName = builder.toString();
        Class<?> paramType = value.getClass();
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{paramType});
        Method setterMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier);
        if (setterMethod == null) {
            EeLogger.ROOT_LOGGER.ignoringProperty(name, methodName, paramType.getName(), clazz.getName());
            return;
        }
        try {
            setterMethod.invoke(object, value);
        }
        catch (Exception e) {
            throw EeMessages.MESSAGES.cannotSetProperty(e, name, clazz.getName());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = maxStatements;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }
}

