/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ProxyInvocationHandler;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.utils.DescriptorUtils;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class ViewService
implements Service<ComponentView> {
    private final InjectedValue<Component> componentInjector = new InjectedValue();
    private final Map<Method, InterceptorFactory> viewInterceptorFactories;
    private final Map<Method, InterceptorFactory> clientInterceptorFactories;
    private final InterceptorFactory clientPostConstruct;
    private final InterceptorFactory clientPreDestroy;
    private final ProxyFactory<?> proxyFactory;
    private final Class<?> viewClass;
    private final Set<Method> asyncMethods;
    private final ViewInstanceFactory viewInstanceFactory;
    private final Map<Class<?>, Object> privateData;
    private volatile ComponentView view;

    public ViewService(ViewConfiguration viewConfiguration) {
        this.viewClass = viewConfiguration.getViewClass();
        ProxyFactory<?> proxyFactory = viewConfiguration.getProxyFactory();
        this.proxyFactory = proxyFactory;
        List methods = proxyFactory.getCachedMethods();
        int methodCount = methods.size();
        this.clientPostConstruct = Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientPostConstructInterceptors());
        this.clientPreDestroy = Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientPreDestroyInterceptors());
        IdentityHashMap<Method, InterceptorFactory> viewInterceptorFactories = new IdentityHashMap<Method, InterceptorFactory>(methodCount);
        IdentityHashMap<Method, InterceptorFactory> clientInterceptorFactories = new IdentityHashMap<Method, InterceptorFactory>(methodCount);
        for (Method method : methods) {
            if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
                viewInterceptorFactories.put(method, Interceptors.getTerminalInterceptorFactory());
                continue;
            }
            viewInterceptorFactories.put(method, Interceptors.getChainedInterceptorFactory(viewConfiguration.getViewInterceptors(method)));
            clientInterceptorFactories.put(method, Interceptors.getChainedInterceptorFactory(viewConfiguration.getClientInterceptors(method)));
        }
        this.viewInterceptorFactories = viewInterceptorFactories;
        this.clientInterceptorFactories = clientInterceptorFactories;
        this.asyncMethods = viewConfiguration.getAsyncMethods();
        this.viewInstanceFactory = viewConfiguration.getViewInstanceFactory() == null ? new DefaultViewInstanceFactory() : viewConfiguration.getViewInstanceFactory();
        this.privateData = viewConfiguration.getPrivateData().isEmpty() ? Collections.emptyMap() : viewConfiguration.getPrivateData();
    }

    public void start(StartContext context) throws StartException {
        View view = new View(this.privateData);
        view.initializeInterceptors();
        this.view = view;
    }

    public void stop(StopContext context) {
        this.view = null;
    }

    public Injector<Component> getComponentInjector() {
        return this.componentInjector;
    }

    public ComponentView getValue() throws IllegalStateException, IllegalArgumentException {
        return this.view;
    }

    private class DefaultViewInstanceFactory
    implements ViewInstanceFactory {
        private DefaultViewInstanceFactory() {
        }

        @Override
        public ManagedReference createViewInstance(final ComponentView componentView, Map<Object, Object> contextData) {
            Object proxy;
            SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
            final Component component = componentView.getComponent();
            factoryContext.getContextData().put(Component.class, component);
            factoryContext.getContextData().put(ComponentView.class, componentView);
            factoryContext.getContextData().putAll(contextData);
            Interceptor clientPostConstructInterceptor = ViewService.this.clientPostConstruct.create((InterceptorFactoryContext)factoryContext);
            final Interceptor clientPreDestroyInterceptor = ViewService.this.clientPreDestroy.create((InterceptorFactoryContext)factoryContext);
            Map clientInterceptorFactories = ViewService.this.clientInterceptorFactories;
            IdentityHashMap<Method, Interceptor> clientEntryPoints = new IdentityHashMap<Method, Interceptor>(clientInterceptorFactories.size());
            for (Method method : clientInterceptorFactories.keySet()) {
                clientEntryPoints.put(method, ((InterceptorFactory)clientInterceptorFactories.get(method)).create((InterceptorFactoryContext)factoryContext));
            }
            try {
                proxy = ViewService.this.proxyFactory.newInstance((InvocationHandler)new ProxyInvocationHandler(clientEntryPoints, component, componentView));
            }
            catch (InstantiationException e) {
                InstantiationError error = new InstantiationError(e.getMessage());
                Throwable cause = e.getCause();
                if (cause != null) {
                    error.initCause(cause);
                }
                throw error;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError error = new IllegalAccessError(e.getMessage());
                Throwable cause = e.getCause();
                if (cause != null) {
                    error.initCause(cause);
                }
                throw error;
            }
            try {
                InterceptorContext context = new InterceptorContext();
                context.putPrivateData(ComponentView.class, (Object)componentView);
                context.putPrivateData(Component.class, (Object)component);
                context.setContextData(new HashMap());
                clientPostConstructInterceptor.processInvocation(context);
            }
            catch (Exception e) {
                throw EeMessages.MESSAGES.componentViewConstructionFailure(e);
            }
            return new ManagedReference(){

                public void release() {
                    try {
                        InterceptorContext interceptorContext = new InterceptorContext();
                        interceptorContext.putPrivateData(ComponentView.class, (Object)componentView);
                        interceptorContext.putPrivateData(Component.class, (Object)component);
                        clientPreDestroyInterceptor.processInvocation(interceptorContext);
                    }
                    catch (Exception e) {
                        EeLogger.ROOT_LOGGER.preDestroyInterceptorFailure(e, component.getComponentClass());
                    }
                }

                public Object getInstance() {
                    return proxy;
                }
            };
        }
    }

    class View
    implements ComponentView {
        private final Component component;
        private final Map<Method, Interceptor> viewInterceptors;
        private final Map<MethodDescription, Method> methods;
        private final Map<Class<?>, Object> privateData;

        View(Map<Class<?>, Object> privateData) {
            this.privateData = privateData;
            this.component = (Component)ViewService.this.componentInjector.getValue();
            this.viewInterceptors = new IdentityHashMap<Method, Interceptor>();
            this.methods = new HashMap<MethodDescription, Method>();
        }

        void initializeInterceptors() {
            SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
            Map viewInterceptorFactories = ViewService.this.viewInterceptorFactories;
            Map<Method, Interceptor> viewEntryPoints = this.viewInterceptors;
            factoryContext.getContextData().put(Component.class, this.component);
            factoryContext.getContextData().put(ComponentView.class, this);
            for (Method method : viewInterceptorFactories.keySet()) {
                viewEntryPoints.put(method, ((InterceptorFactory)viewInterceptorFactories.get(method)).create((InterceptorFactoryContext)factoryContext));
                this.methods.put(new MethodDescription(method.getName(), DescriptorUtils.methodDescriptor(method)), method);
            }
        }

        @Override
        public ManagedReference createInstance() {
            return this.createInstance(Collections.<Object, Object>emptyMap());
        }

        @Override
        public ManagedReference createInstance(Map<Object, Object> contextData) {
            return ViewService.this.viewInstanceFactory.createViewInstance(this, contextData);
        }

        @Override
        public Object invoke(InterceptorContext interceptorContext) throws Exception {
            Method method = interceptorContext.getMethod();
            Interceptor interceptor = this.viewInterceptors.get(method);
            return interceptor.processInvocation(interceptorContext);
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        @Override
        public Class<?> getProxyClass() {
            return ViewService.this.proxyFactory.defineClass();
        }

        @Override
        public Class<?> getViewClass() {
            return ViewService.this.viewClass;
        }

        @Override
        public Set<Method> getViewMethods() {
            return this.viewInterceptors.keySet();
        }

        @Override
        public Method getMethod(String name, String descriptor) {
            Method method = this.methods.get(new MethodDescription(name, descriptor));
            if (method == null) {
                throw EeMessages.MESSAGES.viewMethodNotFound(name, descriptor, ViewService.this.viewClass, this.component.getComponentClass());
            }
            return method;
        }

        @Override
        public <T> T getPrivateData(Class<T> clazz) {
            return (T)this.privateData.get(clazz);
        }

        @Override
        public boolean isAsynchronous(Method method) {
            return ViewService.this.asyncMethods.contains(method);
        }

        public String toString() {
            return "Component view " + ViewService.this.viewClass + " for component " + this.component.getComponentClass();
        }

        private final class MethodDescription {
            private final String name;
            private final String descriptor;

            public MethodDescription(String name, String descriptor) {
                this.name = name;
                this.descriptor = descriptor;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MethodDescription that = (MethodDescription)o;
                if (!this.descriptor.equals(that.descriptor)) {
                    return false;
                }
                return this.name.equals(that.name);
            }

            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + this.descriptor.hashCode();
                return result;
            }
        }
    }
}

