/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.DisplaySecret;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.as.domain.management.security.state.UpdatePropertiesHandler;
import org.jboss.as.domain.management.security.state.UserPropertiesFileHandler;
import org.jboss.msc.service.StartException;

public class AddUser
extends UpdatePropertiesHandler
implements State {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public AddUser(ConsoleWrapper theConsole, StateValues stateValues) {
        super(theConsole);
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        State nextState = this.update(this.stateValues);
        if (nextState == null && this.stateValues.isInteractive()) {
            nextState = new ConfirmationChoice(this.theConsole, DomainManagementMessages.MESSAGES.serverUser(), DomainManagementMessages.MESSAGES.yesNo(), new DisplaySecret(this.theConsole, this.stateValues), null);
        }
        return nextState;
    }

    @Override
    void persist(String[] entry, File file) throws IOException {
        UserPropertiesFileHandler propertiesHandler = new UserPropertiesFileHandler(file.getAbsolutePath());
        try {
            propertiesHandler.start(null);
            Properties prob = propertiesHandler.getProperties();
            prob.setProperty(entry[0], entry[1]);
            propertiesHandler.persistProperties();
        }
        catch (StartException e) {
            throw new IllegalStateException(DomainManagementMessages.MESSAGES.unableToAddUser(file.getAbsolutePath(), e.getMessage()));
        }
        finally {
            propertiesHandler.stop(null);
        }
    }

    @Override
    String consoleUserMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedUser(this.stateValues.getUserName(), filePath);
    }

    @Override
    String consoleRolesMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedRoles(this.stateValues.getUserName(), this.stateValues.getRoles(), filePath);
    }

    @Override
    String errorMessage(String filePath, Throwable e) {
        return DomainManagementMessages.MESSAGES.unableToAddUser(filePath, e.getMessage());
    }
}

