/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public class Util {
    public static final String[] NO_LOCATION = new String[0];

    private Util() {
    }

    public static String getNameFromAddress(ModelNode address) {
        PathElement pe = PathAddress.pathAddress(address).getLastElement();
        return pe == null ? null : pe.getValue();
    }

    public static ModelNode getEmptyOperation(String operationName, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address);
        } else {
            op.get("address");
        }
        return op;
    }

    public static ModelNode getResourceRemoveOperation(ModelNode address) {
        return Util.getEmptyOperation("remove", address);
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, String value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, int value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, boolean value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, ModelNode value) {
        ModelNode op = Util.getEmptyOperation("write-attribute", address);
        op.get("name").set(attributeName);
        op.get("value").set(value);
        return op;
    }

    public static boolean isExpression(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    @Deprecated
    public static void copyParamsToModel(ModelNode operation, ModelNode model) {
        HashSet keys = new HashSet(operation.keys());
        keys.remove("operation");
        keys.remove("address");
        keys.remove("operation-headers");
        for (String key : keys) {
            model.get(key).set(operation.get(key));
        }
    }

    public static ModelNode getOperation(String operationName, ModelNode address, ModelNode params) {
        ModelNode op = Util.getEmptyOperation(operationName, address);
        Set keys = params.keys();
        keys.remove("operation");
        keys.remove("address");
        for (String key : keys) {
            op.get(key).set(params.get(key));
        }
        return op;
    }

    public static PathAddress getParentAddressByKey(PathAddress address, String parentKey) {
        for (int i = address.size() - 1; i >= 0; --i) {
            PathElement pe = address.getElement(i);
            if (!parentKey.equals(pe.getKey())) continue;
            return address.subAddress(0, i + 1);
        }
        return null;
    }
}

