/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.dmr.ModelNode;

public class SystemPropertyValueWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final SystemPropertyValueWriteAttributeHandler INSTANCE = new SystemPropertyValueWriteAttributeHandler();

    private SystemPropertyValueWriteAttributeHandler() {
    }

    @Override
    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) {
                    String propertyName = PathAddress.pathAddress(operation.require("address")).getLastElement().getValue();
                    String propertyValue = newValue.isDefined() ? newValue.asString() : null;
                    SecurityActions.setSystemProperty(propertyName, propertyValue);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        if (currentValue.isDefined()) {
                            SecurityActions.setSystemProperty(propertyName, currentValue.asString());
                        } else {
                            SecurityActions.clearSystemProperty(propertyName);
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

