/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Platform;

public class Validate {
    private static final Logger log;
    private static final FileExecutableChecker fileExecutableChecker;
    private static final String[] ENDINGS;

    public static boolean empty(Object object) {
        return object == null;
    }

    public static boolean empty(String object) {
        return object == null || object.length() == 0;
    }

    public static boolean nonEmpty(String object) {
        return !Validate.empty(object);
    }

    public static void isEmpty(Object object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(String object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidPath(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidUrl(URL url, String message) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidUrl(String url, String message) throws IllegalArgumentException {
        Validate.isEmpty(url, message);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    public static void isExecutable(String path, String message) throws IllegalArgumentException {
        if (!Validate.executable(path)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isCommandExecutable(String command) throws IllegalArgumentException {
        File file = new File(command);
        if (fileExecutableChecker.canExecute(file)) {
            return true;
        }
        if (Platform.getCurrent().is(Platform.WINDOWS) && fileExecutableChecker.canExecute(file = new File(command + ".exe"))) {
            return true;
        }
        ArrayList<String> pathSegmentBuilder = new ArrayList<String>();
        Validate.addPathFromEnvironment(pathSegmentBuilder);
        if (Platform.getCurrent().is(Platform.MAC)) {
            Validate.addMacSpecificPath(pathSegmentBuilder);
        }
        for (String pathSegment : pathSegmentBuilder) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, command + ending);
                if (!fileExecutableChecker.canExecute(file)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addPathFromEnvironment(List<String> pathSegmentBuilder) {
        String path;
        String pathName = "PATH";
        Map<String, String> env = System.getenv();
        if (!env.containsKey(pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        if ((path = env.get(pathName)) != null) {
            pathSegmentBuilder.addAll(Arrays.asList(path.split(File.pathSeparator)));
        }
    }

    private static void addMacSpecificPath(List<String> pathSegmentBuilder) {
        File pathFile = new File("/etc/paths");
        if (pathFile.exists()) {
            try {
                pathSegmentBuilder.addAll(FileUtils.readLines((File)pathFile, (Charset)Charset.defaultCharset()));
            }
            catch (IOException e) {
                log.warning(String.format("There was an error when the file %s was being read: %s", pathFile, e.getMessage()));
            }
        }
    }

    public static boolean executable(String path) {
        if (Validate.empty(path)) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The file %s does not exist", path));
        }
        return fileExecutableChecker.canExecute(file);
    }

    static {
        String[] stringArray;
        log = Logger.getLogger(Validate.class.getName());
        fileExecutableChecker = new FileExecutableChecker();
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "";
            stringArray2[1] = ".cmd";
            stringArray2[2] = ".exe";
            stringArray2[3] = ".com";
            stringArray = stringArray2;
            stringArray2[4] = ".bat";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "";
        }
        ENDINGS = stringArray;
    }

    private static final class FileExecutableChecker {
        private static final Logger log = Logger.getLogger(FileExecutableChecker.class.getName());
        private final Method isExecutableMethod;

        FileExecutableChecker() {
            Method m = null;
            try {
                m = File.class.getMethod("canExecute", new Class[0]);
            }
            catch (SecurityException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            this.isExecutableMethod = m;
        }

        public boolean canExecute(File file) {
            if (this.isExecutableMethod == null) {
                return true;
            }
            Boolean result = true;
            try {
                result = (Boolean)this.isExecutableMethod.invoke((Object)file, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            return result;
        }
    }
}

