/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.execution;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.test.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.container.test.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.container.test.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.client.protocol.ProtocolConfiguration;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.context.ApplicationContext;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.context.TestContext;

public class RemoteTestExecuter {
    @Inject
    private Instance<DeploymentDescription> deployment;
    @Inject
    private Instance<Container> container;
    @Inject
    private Instance<ProtocolRegistry> protocolRegistry;
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;
    @Inject
    private Event<Object> remoteEvent;
    @Inject
    @TestScoped
    private InstanceProducer<TestResult> testResult;
    @Inject
    private Instance<ApplicationContext> applicationContextInst;
    @Inject
    private Instance<SuiteContext> suiteContextInst;
    @Inject
    private Instance<ClassContext> classContextInst;
    @Inject
    private Instance<TestContext> testContextInst;

    public void execute(@Observes RemoteExecutionEvent event) throws Exception {
        Container container = (Container)this.container.get();
        DeploymentDescription deployment = (DeploymentDescription)this.deployment.get();
        ProtocolRegistry protoReg = (ProtocolRegistry)this.protocolRegistry.get();
        ProtocolDefinition protocol = protoReg.getProtocol(deployment.getProtocol());
        if (protocol == null) {
            protocol = protoReg.getProtocol(container.getDeployableContainer().getDefaultProtocol());
        }
        ProtocolConfiguration protocolConfiguration = container.hasProtocolConfiguration(protocol.getProtocolDescription()) ? protocol.createProtocolConfiguration(container.getProtocolConfiguration(protocol.getProtocolDescription()).getProtocolProperties()) : protocol.createProtocolConfiguration();
        ContainerMethodExecutor executor = this.getContainerMethodExecutor(protocol, protocolConfiguration);
        this.testResult.set((Object)executor.invoke(event.getExecutor()));
    }

    public ContainerMethodExecutor getContainerMethodExecutor(ProtocolDefinition protocol, ProtocolConfiguration protocolConfiguration) {
        final ApplicationContext applicationContext = (ApplicationContext)this.applicationContextInst.get();
        final SuiteContext suiteContext = (SuiteContext)this.suiteContextInst.get();
        final ClassContext classContext = (ClassContext)this.classContextInst.get();
        final Class classContextId = (Class)classContext.getActiveId();
        final TestContext testContext = (TestContext)this.testContextInst.get();
        final Object testContextId = testContext.getActiveId();
        ContainerMethodExecutor executor = protocol.getProtocol().getExecutor(protocolConfiguration, (ProtocolMetaData)this.protocolMetadata.get(), new CommandCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fired(Command<?> event) {
                applicationContext.activate();
                suiteContext.activate();
                classContext.activate((Object)classContextId);
                testContext.activate(testContextId);
                try {
                    RemoteTestExecuter.this.remoteEvent.fire(event);
                }
                finally {
                    testContext.deactivate();
                    classContext.deactivate();
                    suiteContext.deactivate();
                    applicationContext.deactivate();
                }
            }
        });
        return executor;
    }
}

