/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.container.impl.MapObject;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerImpl
implements Container {
    private DeployableContainer<?> deployableContainer;
    private String name;
    private ContainerDef containerConfiguration;

    public ContainerImpl(String name, DeployableContainer<?> deployableContainer, ContainerDef containerConfiguration) {
        Validate.notNull((Object)name, (String)"Name must be specified");
        Validate.notNull(deployableContainer, (String)"DeployableContainer must be specified");
        Validate.notNull((Object)containerConfiguration, (String)"ConfigurationConfiguration must be specified");
        this.name = name;
        this.deployableContainer = deployableContainer;
        this.containerConfiguration = containerConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public DeployableContainer<?> getDeployableContainer() {
        return this.deployableContainer;
    }

    public ContainerDef getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public ContainerConfiguration createDeployableConfiguration() throws Exception {
        ContainerConfiguration config = (ContainerConfiguration)this.deployableContainer.getConfigurationClass().newInstance();
        MapObject.populate(config, this.containerConfiguration.getContainerProperties());
        config.validate();
        return config;
    }

    public boolean hasProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return true;
        }
        return false;
    }

    public ProtocolDef getProtocolConfiguration(ProtocolDescription description) {
        for (ProtocolDef protocol : this.containerConfiguration.getProtocols()) {
            if (!description.getName().equals(protocol.getType())) continue;
            return protocol;
        }
        return null;
    }
}

