/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.concurrent.locks.containers.AbstractLockContainer;

public abstract class AbstractPerEntryLockContainer<L extends Lock>
extends AbstractLockContainer<L> {
    protected final ConcurrentMap<Object, L> locks;

    protected AbstractPerEntryLockContainer(int concurrencyLevel) {
        this.locks = ConcurrentMapFactory.makeConcurrentMap(16, concurrencyLevel);
    }

    protected abstract L newLock();

    @Override
    public final L getLock(Object key) {
        Lock existingLock;
        Lock lock = (Lock)this.locks.get(key);
        if (lock == null && (existingLock = this.locks.putIfAbsent(key, lock = this.newLock())) != null) {
            lock = existingLock;
        }
        return (L)lock;
    }

    @Override
    public int getNumLocksHeld() {
        return this.locks.size();
    }

    @Override
    public int size() {
        return this.locks.size();
    }

    @Override
    public L acquireLock(Object lockOwner, Object key, long timeout, TimeUnit unit) throws InterruptedException {
        block4: {
            L lock;
            while (true) {
                boolean locked;
                lock = this.getLock(key);
                try {
                    locked = this.tryLock(lock, timeout, unit, lockOwner);
                }
                catch (InterruptedException ie) {
                    this.safeRelease(lock, lockOwner);
                    throw ie;
                }
                catch (Throwable th) {
                    locked = false;
                }
                if (!locked) break block4;
                Lock existingLock = (Lock)this.locks.putIfAbsent(key, lock);
                if (existingLock == null || existingLock == lock) break;
                this.safeRelease(lock, lockOwner);
            }
            return lock;
        }
        return null;
    }

    @Override
    public void releaseLock(Object lockOwner, Object key) {
        Lock l = (Lock)this.locks.remove(key);
        if (l != null) {
            this.unlock(l, lockOwner);
        }
    }

    @Override
    public int getLockId(Object key) {
        return System.identityHashCode(this.getLock(key));
    }
}

