/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public enum Flag {
    ZERO_LOCK_ACQUISITION_TIMEOUT,
    CACHE_MODE_LOCAL,
    SKIP_LOCKING,
    FORCE_WRITE_LOCK,
    SKIP_CACHE_STATUS_CHECK,
    FORCE_ASYNCHRONOUS,
    FORCE_SYNCHRONOUS,
    SKIP_CACHE_STORE,
    SKIP_CACHE_LOAD,
    FAIL_SILENTLY,
    SKIP_REMOTE_LOOKUP,
    SKIP_INDEXING,
    PUT_FOR_EXTERNAL_READ,
    SKIP_SHARED_CACHE_STORE,
    REMOVE_DATA_ON_STOP,
    SKIP_OWNERSHIP_CHECK;


    protected static Set<Flag> copyWithouthRemotableFlags(Set<Flag> flags) {
        if (flags.contains((Object)FAIL_SILENTLY)) {
            EnumSet<Flag> copy = EnumSet.copyOf(flags);
            copy.remove((Object)FAIL_SILENTLY);
            if (copy.isEmpty()) {
                return Collections.emptySet();
            }
            return copy;
        }
        return flags;
    }

    public static class Externalizer
    extends AbstractExternalizer<Flag> {
        @Override
        public Integer getId() {
            return 85;
        }

        @Override
        public Set<Class<? extends Flag>> getTypeClasses() {
            return Util.asSet(Flag.class);
        }

        @Override
        public void writeObject(ObjectOutput output, Flag object) throws IOException {
            output.writeByte(object.ordinal());
        }

        @Override
        public Flag readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte flagByte = input.readByte();
            try {
                return Flag.values()[flagByte];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalStateException("Unknown flag index: " + flagByte);
            }
        }
    }
}

