/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.ControlledTransport;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverDelegator;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.commands.XSiteBringOnlineCommand;
import org.infinispan.xsite.commands.XSiteStateTransferCancelSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferFinishReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartReceiveCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStartSendCommand;
import org.infinispan.xsite.commands.XSiteStateTransferStatusRequestCommand;
import org.infinispan.xsite.commands.remote.XSiteStatePushRequest;
import org.infinispan.xsite.commands.remote.XSiteStateTransferControlRequest;
import org.infinispan.xsite.statetransfer.AbstractStateTransferTest;
import org.infinispan.xsite.statetransfer.XSiteProviderDelegator;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public abstract class BaseStateTransferTest
extends AbstractStateTransferTest {
    private static final String VALUE = "value";

    BaseStateTransferTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.cacheMode = CacheMode.DIST_SYNC;
    }

    @Test(groups={"xsite"})
    public void testStateTransferNonExistingSite() {
        XSiteAdminOperations operations = this.adminOperations();
        AssertJUnit.assertEquals((String)"Unable to pushState to 'NO_SITE'. Incorrect site name: NO_SITE", (String)operations.pushState("NO_SITE"));
        AssertJUnit.assertTrue((boolean)operations.getRunningStateTransfer().isEmpty());
        this.assertNoStateTransferInSendingSite();
    }

    @Test(groups={"xsite"}, enabled=false, description="Disabled as part of https://github.com/infinispan/infinispan/issues/14618")
    public void testCancelStateTransfer(Method method) throws InterruptedException {
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(null);
        this.assertNoStateTransferInSendingSite();
        LocalizedCacheTopology topology = this.cache("LON-1", 0).getAdvancedCache().getDistributionManager().getCacheTopology();
        Address coordLON = this.cache("LON-1", 0).getCacheManager().getAddress();
        HashSet<String> keysOnCoordinator = new HashSet<String>();
        int i = 0;
        while (keysOnCoordinator.size() < this.chunkSize()) {
            String key = TestingUtil.k(method, i);
            this.cache("LON-1", 0).put((Object)key, (Object)VALUE);
            if (topology.getDistribution((Object)key).primary().equals((Object)coordLON)) {
                keysOnCoordinator.add(key);
            }
            ++i;
        }
        int numKeys = i;
        log.debugf("Coordinator %s is primary owner for %d keys: %s", (Object)coordLON, (Object)keysOnCoordinator.size(), keysOnCoordinator);
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
        ControlledTransport controlledTransport = ControlledTransport.replace(this.cache("LON-1", 0));
        controlledTransport.excludeCommands(XSiteBringOnlineCommand.class, XSiteStateTransferStartReceiveCommand.class, XSiteStateTransferControlRequest.class, XSiteStateTransferStartSendCommand.class, XSiteStateTransferCancelSendCommand.class, XSiteStateTransferFinishReceiveCommand.class, XSiteStateTransferStatusRequestCommand.class);
        controlledTransport.excludeCacheCommands();
        this.startStateTransfer();
        ControlledTransport.BlockedRequest<XSiteStatePushRequest> pushRequest = controlledTransport.expectCommand(XSiteStatePushRequest.class);
        AssertJUnit.assertEquals((String)"ok", (String)this.adminOperations().cancelPushState("NYC-2"));
        pushRequest.send().receiveAll();
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
        AssertJUnit.assertEquals((String)"CANCELED", (String)((String)this.adminOperations().getPushStateStatus().get("NYC-2")));
        this.startStateTransfer();
        ControlledTransport.BlockedRequest<XSiteStatePushRequest> pushRequest2 = controlledTransport.expectCommand(XSiteStatePushRequest.class);
        AssertJUnit.assertEquals((String)"SENDING", (String)((String)this.adminOperations().getPushStateStatus().get("NYC-2")));
        pushRequest2.send().receiveAll();
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
        this.assertInSite("NYC-2", cache -> {
            for (int i1 = 0; i1 < numKeys; ++i1) {
                AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get((Object)TestingUtil.k(method, i1)));
            }
        });
        controlledTransport.stopBlocking();
    }

    @Test(groups={"xsite"})
    public void testStateTransferWithClusterIdle(Method method) {
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(null);
        this.assertNoStateTransferInSendingSite();
        int amountOfData = this.chunkSize() * 4;
        for (int i = 0; i < amountOfData; ++i) {
            this.cache("LON-1", 0).put((Object)TestingUtil.k(method, i), (Object)VALUE);
        }
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertTrue((boolean)cache.isEmpty()));
        this.startStateTransfer();
        this.assertEventuallyStateTransferNotRunning();
        this.assertOnline("LON-1", "NYC-2");
        this.assertInSite("NYC-2", cache -> {
            for (int i = 0; i < amountOfData; ++i) {
                AssertJUnit.assertEquals((Object)VALUE, (Object)cache.get((Object)TestingUtil.k(method, i)));
            }
        });
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
    }

    @Test(groups={"xsite"})
    public void testPutOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.PUT, true, method);
    }

    @Test(groups={"xsite"})
    public void testPutOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.PUT, false, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REMOVE, true, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REMOVE, false, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveIfMatchOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REMOVE_IF_MATCH, true, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveIfMatchOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REMOVE_IF_MATCH, false, method);
    }

    @Test(groups={"xsite"})
    public void testReplaceOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REPLACE, true, method);
    }

    @Test(groups={"xsite"})
    public void testReplaceOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REPLACE, false, method);
    }

    @Test(groups={"xsite"})
    public void testReplaceIfMatchOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REPLACE_IF_MATCH, true, method);
    }

    @Test(groups={"xsite"})
    public void testReplaceIfMatchOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.REPLACE_IF_MATCH, false, method);
    }

    @Test(groups={"xsite"})
    public void testClearOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.CLEAR, true, method);
    }

    @Test(groups={"xsite"})
    public void testClearOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.CLEAR, false, method);
    }

    @Test(groups={"xsite"})
    public void testPutMapOperationBeforeState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.PUT_MAP, true, method);
    }

    @Test(groups={"xsite"})
    public void testPutMapOperationAfterState(Method method) throws Exception {
        this.testStateTransferWithConcurrentOperation(Operation.PUT_MAP, false, method);
    }

    @Test(groups={"xsite"})
    public void testPutIfAbsentFail(Method method) throws Exception {
        this.testStateTransferWithNoReplicatedOperation(Operation.PUT_IF_ABSENT_FAIL, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveIfMatchFail(Method method) throws Exception {
        this.testStateTransferWithNoReplicatedOperation(Operation.REMOVE_IF_MATCH_FAIL, method);
    }

    @Test(groups={"xsite"})
    public void testReplaceIfMatchFail(Method method) throws Exception {
        this.testStateTransferWithNoReplicatedOperation(Operation.REPLACE_IF_MATCH_FAIL, method);
    }

    @Test(groups={"xsite"})
    public void testPutIfAbsent(Method method) throws Exception {
        this.testConcurrentOperation(Operation.PUT_IF_ABSENT, method);
    }

    @Test(groups={"xsite"})
    public void testRemoveNonExisting(Method method) throws Exception {
        this.testConcurrentOperation(Operation.REMOVE_NON_EXISTING, method);
    }

    @Override
    protected void adaptLONConfiguration(BackupConfigurationBuilder builder) {
        builder.stateTransfer().chunkSize(2).timeout(2000L);
    }

    private void testStateTransferWithConcurrentOperation(final Operation operation, final boolean performBeforeState, Method method) throws Exception {
        AssertJUnit.assertNotNull((Object)((Object)operation));
        AssertJUnit.assertTrue((boolean)operation.replicates());
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(null);
        this.assertNoStateTransferInSendingSite();
        final String key = TestingUtil.k(method, 0);
        final CheckPoint checkPoint = new CheckPoint();
        operation.init(this.cache("LON-1", 0), key);
        AssertJUnit.assertNotNull((Object)operation.initialValue());
        BackupListener listener = new BackupListener(this){
            final /* synthetic */ BaseStateTransferTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void beforeCommand(VisitableCommand command) throws Exception {
                checkPoint.trigger("before-update");
                if (!performBeforeState && this.this$0.isUpdatingKeyWithValue(command, key, operation.finalValue())) {
                    checkPoint.awaitStrict("update-key", 30L, TimeUnit.SECONDS);
                }
            }

            @Override
            public void afterCommand(VisitableCommand command) {
                if (performBeforeState && this.this$0.isUpdatingKeyWithValue(command, key, operation.finalValue())) {
                    checkPoint.trigger("apply-state");
                }
            }

            @Override
            public void beforeState(XSiteState[] chunk) throws Exception {
                checkPoint.trigger("before-state");
                checkPoint.awaitStrict("before-update", 30L, TimeUnit.SECONDS);
                if (performBeforeState && this.this$0.containsKey(chunk, key)) {
                    checkPoint.awaitStrict("apply-state", 30L, TimeUnit.SECONDS);
                }
            }

            @Override
            public void afterState(XSiteState[] chunk) {
                if (!performBeforeState && this.this$0.containsKey(chunk, key)) {
                    checkPoint.trigger("update-key");
                }
            }
        };
        for (Cache cache2 : this.caches("NYC-2")) {
            TestingUtil.wrapComponent(cache2, BackupReceiver.class, current -> new ListenableBackupReceiver((BackupReceiver)current, listener));
        }
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        checkPoint.awaitStrict("before-state", 30L, TimeUnit.SECONDS);
        operation.perform(this.cache("LON-1", 0), key).get();
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
        this.assertInSite("LON-1", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
    }

    private void testConcurrentOperation(Operation operation, Method method) throws Exception {
        AssertJUnit.assertNotNull((Object)((Object)operation));
        AssertJUnit.assertTrue((boolean)operation.replicates());
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(null);
        this.assertNoStateTransferInSendingSite();
        String key = TestingUtil.k(method, 0);
        operation.init(this.cache("LON-1", 0), key);
        AssertJUnit.assertNull((Object)operation.initialValue());
        XSiteStateProviderControl control = XSiteStateProviderControl.replaceInCache(this.cache("LON-1", 0));
        Future<Void> f = this.fork(this::startStateTransfer);
        control.await();
        this.assertOnline("LON-1", "NYC-2");
        operation.perform(this.cache("LON-1", 0), key).get();
        control.trigger();
        f.get(30L, TimeUnit.SECONDS);
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
        this.assertInSite("LON-1", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
    }

    private void testStateTransferWithNoReplicatedOperation(Operation operation, Method method) throws Exception {
        AssertJUnit.assertNotNull((Object)((Object)operation));
        AssertJUnit.assertFalse((boolean)operation.replicates());
        this.takeSiteOffline();
        this.assertOffline();
        this.assertNoStateTransferInReceivingSite(null);
        this.assertNoStateTransferInSendingSite();
        String key = TestingUtil.k(method, 0);
        final CheckPoint checkPoint = new CheckPoint();
        final AtomicBoolean commandReceived = new AtomicBoolean(false);
        operation.init(this.cache("LON-1", 0), key);
        AssertJUnit.assertNotNull((Object)operation.initialValue());
        BackupListener listener = new BackupListener(this){
            final /* synthetic */ BaseStateTransferTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void beforeCommand(VisitableCommand command) {
                commandReceived.set(true);
            }

            @Override
            public void afterCommand(VisitableCommand command) {
                commandReceived.set(true);
            }

            @Override
            public void beforeState(XSiteState[] chunk) throws Exception {
                checkPoint.trigger("before-state");
                checkPoint.awaitStrict("before-update", 30L, TimeUnit.SECONDS);
            }
        };
        for (Cache cache2 : this.caches("NYC-2")) {
            TestingUtil.wrapComponent(cache2, BackupReceiver.class, current -> new ListenableBackupReceiver((BackupReceiver)current, listener));
        }
        this.startStateTransfer();
        this.assertOnline("LON-1", "NYC-2");
        checkPoint.awaitStrict("before-state", 30L, TimeUnit.SECONDS);
        operation.perform(this.cache("LON-1", 0), key).get();
        AssertJUnit.assertFalse((boolean)commandReceived.get());
        checkPoint.trigger("before-update");
        this.assertEventuallyStateTransferNotRunning();
        this.assertEventuallyNoStateTransferInReceivingSite(null);
        this.assertEventuallyNoStateTransferInSendingSite();
        this.assertInSite("NYC-2", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
        this.assertInSite("LON-1", cache -> AssertJUnit.assertEquals((Object)operation.finalValue(), (Object)cache.get(key)));
    }

    private boolean isUpdatingKeyWithValue(VisitableCommand command, Object key, Object value) {
        if (command instanceof PutKeyValueCommand) {
            return key.equals(((PutKeyValueCommand)command).getKey()) && value.equals(((PutKeyValueCommand)command).getValue());
        }
        if (command instanceof RemoveCommand) {
            return key.equals(((RemoveCommand)command).getKey());
        }
        if (command instanceof ClearCommand) {
            return true;
        }
        if (command instanceof WriteOnlyManyEntriesCommand) {
            InternalCacheValue icv = (InternalCacheValue)((WriteOnlyManyEntriesCommand)command).getArguments().get(key);
            return Objects.equals(icv.getValue(), value);
        }
        if (command instanceof PrepareCommand) {
            for (WriteCommand writeCommand : ((PrepareCommand)command).getModifications()) {
                if (!this.isUpdatingKeyWithValue((VisitableCommand)writeCommand, key, value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsKey(XSiteState[] states, Object key) {
        if (states == null || states.length == 0 || key == null) {
            return false;
        }
        for (XSiteState state : states) {
            if (!key.equals(state.key())) continue;
            return true;
        }
        return false;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Operation {
        PUT("v0", "v1"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.putAsync(key, this.finalValue());
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        PUT_IF_ABSENT(null, "v1"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.putIfAbsentAsync(key, this.finalValue());
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        PUT_IF_ABSENT_FAIL("v0", "v0"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.putIfAbsentAsync(key, (Object)"v1");
            }

            @Override
            public boolean replicates() {
                return false;
            }
        }
        ,
        REPLACE("v0", "v1"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.replaceAsync(key, this.finalValue());
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        REPLACE_NON_EXISTING(null, null){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.replaceAsync(key, (Object)"v1");
            }

            @Override
            public boolean replicates() {
                return false;
            }
        }
        ,
        REPLACE_IF_MATCH("v0", "v1"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.replaceAsync(key, this.initialValue(), this.finalValue());
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        REPLACE_IF_MATCH_FAIL("v0", "v0"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.replaceAsync(key, (Object)"v1", (Object)"v1");
            }

            @Override
            public boolean replicates() {
                return false;
            }
        }
        ,
        REMOVE_NON_EXISTING(null, null){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.removeAsync(key);
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        REMOVE("v0", null){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.removeAsync(key);
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        REMOVE_IF_MATCH("v0", null){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.removeAsync(key, this.initialValue());
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        REMOVE_IF_MATCH_FAIL("v0", "v0"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.removeAsync(key, (Object)"v1");
            }

            @Override
            public boolean replicates() {
                return false;
            }
        }
        ,
        CLEAR("v0", null){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                return cache.clearAsync();
            }

            @Override
            public boolean replicates() {
                return true;
            }
        }
        ,
        PUT_MAP("v0", "v1"){

            @Override
            public <K> void init(Cache<K, Object> cache, K key) {
                cache.put(key, this.initialValue());
            }

            @Override
            public <K> Future<?> perform(Cache<K, Object> cache, K key) {
                HashMap<K, Object> map = new HashMap<K, Object>();
                map.put(key, this.finalValue());
                return cache.putAllAsync(map);
            }

            @Override
            public boolean replicates() {
                return true;
            }
        };

        private final Object initialValue;
        private final Object finalValue;

        private Operation(Object initialValue, Object finalValue) {
            this.initialValue = initialValue;
            this.finalValue = finalValue;
        }

        final Object initialValue() {
            return this.initialValue;
        }

        final Object finalValue() {
            return this.finalValue;
        }

        protected abstract <K> void init(Cache<K, Object> var1, K var2);

        protected abstract <K> Future<?> perform(Cache<K, Object> var1, K var2);

        protected abstract boolean replicates();
    }

    private static abstract class BackupListener {
        private BackupListener() {
        }

        void beforeCommand(VisitableCommand command) throws Exception {
        }

        void afterCommand(VisitableCommand command) {
        }

        void beforeState(XSiteState[] chunk) throws Exception {
        }

        void afterState(XSiteState[] chunk) {
        }
    }

    private static class XSiteStateProviderControl
    extends XSiteProviderDelegator {
        private final CheckPoint checkPoint = new CheckPoint();

        private XSiteStateProviderControl(XSiteStateProvider xSiteStateProvider) {
            super(xSiteStateProvider);
        }

        @Override
        public void startStateTransfer(String siteName, Address requestor, int minTopologyId) {
            this.checkPoint.trigger("before-start");
            try {
                this.checkPoint.awaitStrict("await-start", 30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
            super.startStateTransfer(siteName, requestor, minTopologyId);
        }

        static XSiteStateProviderControl replaceInCache(Cache<?, ?> cache) {
            XSiteStateProvider current = TestingUtil.extractComponent(cache, XSiteStateProvider.class);
            XSiteStateProviderControl control = new XSiteStateProviderControl(current);
            TestingUtil.replaceComponent(cache, XSiteStateProvider.class, control, true);
            return control;
        }

        final void await() throws TimeoutException, InterruptedException {
            this.checkPoint.awaitStrict("before-start", 30L, TimeUnit.SECONDS);
        }

        final void trigger() {
            this.checkPoint.trigger("await-start");
        }
    }

    private static class ListenableBackupReceiver
    extends BackupReceiverDelegator {
        private final BackupListener listener;

        ListenableBackupReceiver(BackupReceiver delegate, BackupListener listener) {
            super(delegate);
            this.listener = Objects.requireNonNull(listener, "Listener must not be null.");
        }

        @Override
        public <O> CompletionStage<O> handleRemoteCommand(VisitableCommand command) {
            try {
                this.listener.beforeCommand(command);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
            return super.handleRemoteCommand(command).whenComplete((v, t) -> this.listener.afterCommand(command));
        }

        @Override
        public CompletionStage<Void> handleStateTransferState(XSiteState[] chunk, long timeoutMs) {
            try {
                this.listener.beforeState(chunk);
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
            return super.handleStateTransferState(chunk, timeoutMs).whenComplete((v, t) -> this.listener.afterState(chunk));
        }
    }
}

