/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.test.AbstractInfinispanTest;

@SerializeWith(value=Externalizer.class)
public class TestClassLocal<T>
implements Serializable {
    private static final Map<String, TestClassLocal> values = new ConcurrentHashMap<String, TestClassLocal>();
    private final String name;
    private final AbstractInfinispanTest test;
    private final Supplier<T> supplier;
    private final Consumer<T> destroyer;
    private Object value;

    public TestClassLocal(String name, AbstractInfinispanTest test, Supplier<T> supplier, Consumer<T> destroyer) {
        this.name = name;
        this.test = test;
        this.supplier = supplier;
        this.destroyer = destroyer;
        values.put(this.id(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        TestClassLocal testClassLocal = this;
        synchronized (testClassLocal) {
            if (this.value == null) {
                this.value = this.supplier.get();
                TestResourceTracker.addResource((String)this.test.getTestName(), (TestResourceTracker.Cleaner)new TestResourceTracker.Cleaner<TestClassLocal<T>>(this){

                    public void close() {
                        ((TestClassLocal)this.ref).destroyer.accept(((TestClassLocal)this.ref).get());
                    }
                });
            }
            return (T)this.value;
        }
    }

    void close() {
        TestClassLocal value = values.remove(this);
        this.destroyer.accept(value);
    }

    public String id() {
        return this.name + "/" + this.test.toString();
    }

    public String toString() {
        return this.id();
    }

    public static class Externalizer
    implements org.infinispan.commons.marshall.Externalizer<TestClassLocal> {
        public void writeObject(ObjectOutput output, TestClassLocal object) throws IOException {
            output.writeUTF(object.id());
        }

        public TestClassLocal readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String id = input.readUTF();
            return values.get(id);
        }
    }
}

