/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.DenyReadWritesStreamTest")
public class DenyReadWritesStreamTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(DenyReadWritesStreamTest.class);
    public static final int CHUNK_SIZE = 2;
    public static final int NUM_KEYS = 20;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        this.cacheManager = new DefaultCacheManager(global.build());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().chunkSize(2).hash().numOwners(4);
        builder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        this.cacheManager.defineConfiguration("testCache", builder.build());
        this.cache = this.cacheManager.getCache("testCache");
        for (int i = 0; i < 20; ++i) {
            this.cache.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
        return this.cacheManager;
    }

    @Override
    protected void clearCacheManager() {
    }

    public void testValuesForEachNoBatchSize() {
        try (CacheStream cacheStream = this.cache.values().stream();){
            cacheStream.forEach((SerializableConsumer & Serializable)v -> log.tracef("foreach: %s", v));
        }
    }

    public void testEntriesIteratorNoBatchSize() {
        try (CloseableIterator it = this.cache.entrySet().iterator();){
            while (it.hasNext()) {
                Object key = it.next();
                log.tracef("iterator: %s", key);
            }
        }
    }

    public void testKeysForEachBatchSizeEqualsCacheSize() {
        try (CacheStream cacheStream = this.cache.keySet().stream().distributedBatchSize(20);){
            cacheStream.forEach((SerializableConsumer & Serializable)k -> log.tracef("foreach: %s", k));
        }
    }

    public void testKeysForEachBatchSizeIsLessThanCacheSize() {
        try (CacheStream cacheStream = this.cache.keySet().stream().distributedBatchSize(18);){
            cacheStream.forEach((SerializableConsumer & Serializable)k -> log.tracef("foreach %s", k));
        }
    }
}

