/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.ReplicationExceptionTest")
public class ReplicationExceptionTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder configuration = ReplicationExceptionTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        configuration.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(60000L).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.createClusteredCaches(2, "syncReplCache", configuration);
        this.waitForClusterToForm("syncReplCache");
        ConfigurationBuilder noTx = ReplicationExceptionTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        noTx.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(60000L);
        this.defineConfigurationOnAllManagers("syncReplCacheNoTx", noTx);
        ConfigurationBuilder replAsyncNoTx = ReplicationExceptionTest.getDefaultClusteredCacheConfig(CacheMode.REPL_ASYNC, false);
        this.defineConfigurationOnAllManagers("asyncReplCacheNoTx", replAsyncNoTx);
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        AdvancedCache cache1 = this.cache(0, "syncReplCache").getAdvancedCache();
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        return mgr;
    }

    @Test(expectedExceptions={MarshallingException.class})
    public void testNonMarshallableRepl() {
        this.doNonMarshallableReplTest("syncReplCacheNoTx");
    }

    @Test(expectedExceptions={MarshallingException.class})
    public void testNonMarshallableAsyncRepl() {
        this.doNonMarshallableReplTest("asyncReplCacheNoTx");
    }

    private void doNonMarshallableReplTest(String cacheName) {
        AdvancedCache cache1 = this.advancedCache(0, cacheName);
        AdvancedCache cache2 = this.advancedCache(1, cacheName);
        cache1.put((Object)"test", (Object)new ContainerData());
    }

    public void testNonSerializableReplWithTx() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "syncReplCache");
        AdvancedCache cache2 = this.advancedCache(1, "syncReplCache");
        try {
            TransactionManager tm = this.beginTransaction();
            cache1.put((Object)"test", (Object)new ContainerData());
            tm.commit();
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)cache2.get((Object)"test"));
        }
        catch (RollbackException rollback) {
            log.trace((Object)"received RollbackException - as expected");
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    @Test(groups={"functional"}, expectedExceptions={CacheException.class})
    public void testSyncReplTimeout() {
        AdvancedCache cache1 = this.advancedCache(0, "syncReplCache");
        AdvancedCache cache2 = this.advancedCache(1, "syncReplCache");
        TestingUtil.extractInterceptorChain(cache2).addInterceptor((AsyncInterceptor)new DelayInterceptor(), 0);
        cache1.getCacheConfiguration().clustering().remoteTimeout(10L);
        cache2.getCacheConfiguration().clustering().remoteTimeout(10L);
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{cache1, cache2});
        cache1.put((Object)"k", (Object)"v");
    }

    @Test(groups={"functional"}, expectedExceptions={CacheException.class})
    public void testLockAcquisitionTimeout() throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "syncReplCache");
        AdvancedCache cache2 = this.advancedCache(1, "syncReplCache");
        cache1.getCacheConfiguration().locking().lockAcquisitionTimeout(10L);
        cache2.getCacheConfiguration().locking().lockAcquisitionTimeout(10L);
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{cache1, cache2});
        EmbeddedTransactionManager tm = (EmbeddedTransactionManager)TestingUtil.getTransactionManager(cache2);
        tm.begin();
        cache2.put((Object)"block", (Object)"block");
        AssertJUnit.assertTrue((boolean)tm.getTransaction().runPrepare());
        tm.suspend();
        cache1.put((Object)"block", (Object)"v");
    }

    public static class ContainerData
    implements Serializable {
        int i = 99;
        NonSerializabeData non_serializable_data = new NonSerializabeData();
        private static final long serialVersionUID = -8322197791060897247L;
    }

    static class DelayInterceptor
    extends BaseAsyncInterceptor {
        DelayInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            Thread.sleep(100L);
            return this.invokeNext(ctx, command);
        }
    }

    static class NonSerializabeData {
        int i;

        NonSerializabeData() {
        }
    }
}

