/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.MockBasicComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.PrimaryOwnerCacheListener;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.BlockingManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="notifications.cachelistener.OnlyPrimaryOwnerTest", groups={"unit"})
public class OnlyPrimaryOwnerTest {
    CacheNotifierImpl n;
    EncoderCache mockCache;
    PrimaryOwnerCacheListener cl;
    InvocationContext ctx;
    MockCDL cdl = new MockCDL();

    @BeforeMethod
    public void setUp() {
        this.n = new CacheNotifierImpl();
        this.mockCache = (EncoderCache)Mockito.mock(EncoderCache.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        Mockito.when((Object)this.mockCache.getCacheManager()).thenReturn((Object)cacheManager);
        Mockito.when((Object)this.mockCache.getAdvancedCache()).thenReturn((Object)this.mockCache);
        Mockito.when((Object)this.mockCache.getKeyDataConversion()).thenReturn((Object)DataConversion.IDENTITY_KEY);
        Mockito.when((Object)this.mockCache.getValueDataConversion()).thenReturn((Object)DataConversion.IDENTITY_VALUE);
        Mockito.when((Object)this.mockCache.getStatus()).thenReturn((Object)ComponentStatus.INITIALIZING);
        ComponentRegistry componentRegistry = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        Mockito.when((Object)this.mockCache.getComponentRegistry()).thenReturn((Object)componentRegistry);
        MockBasicComponentRegistry mockRegistry = new MockBasicComponentRegistry();
        Mockito.when((Object)((BasicComponentRegistry)componentRegistry.getComponent(BasicComponentRegistry.class))).thenReturn((Object)mockRegistry);
        mockRegistry.registerMocks(RpcManager.class, CommandsFactory.class, Encoder.class);
        mockRegistry.registerMock("org.infinispan.marshaller.internal", StreamingMarshaller.class);
        Configuration config = new ConfigurationBuilder().memory().storageType(StorageType.OBJECT).build();
        ClusterEventManager cem = (ClusterEventManager)Mockito.mock(ClusterEventManager.class);
        Mockito.when((Object)cem.sendEvents(ArgumentMatchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        TestingUtil.inject(this.n, this.mockCache, this.cdl, config, mockRegistry, Mockito.mock(InternalEntryFactory.class), cem, Mockito.mock(KeyPartitioner.class), Mockito.mock(BlockingManager.class));
        this.cl = new PrimaryOwnerCacheListener();
        this.n.start();
        this.n.addListener((Object)this.cl);
        this.ctx = new NonTxInvocationContext(null);
    }

    public void testOwnership() {
        this.cdl.isOwner = false;
        this.cdl.isPrimaryOwner = false;
        this.n.notifyCacheEntryCreated((Object)"reject", (Object)"v1", null, true, this.ctx, null);
        this.n.notifyCacheEntryCreated((Object)"reject", (Object)"v1", null, false, this.ctx, null);
        assert (!this.cl.isReceivedPost());
        assert (!this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 0);
        this.cdl.isOwner = true;
        this.cdl.isPrimaryOwner = false;
        this.n.notifyCacheEntryCreated((Object)"reject", (Object)"v1", null, true, this.ctx, null);
        this.n.notifyCacheEntryCreated((Object)"reject", (Object)"v1", null, false, this.ctx, null);
        assert (!this.cl.isReceivedPost());
        assert (!this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 0);
        this.cdl.isOwner = true;
        this.cdl.isPrimaryOwner = true;
        this.n.notifyCacheEntryCreated((Object)"accept", (Object)"v1", null, true, this.ctx, null);
        this.n.notifyCacheEntryCreated((Object)"accept", (Object)"v1", null, false, this.ctx, null);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_CREATED);
        assert (((CacheEntryCreatedEvent)this.cl.getEvents().get(0)).getKey().equals("accept"));
        assert (((CacheEntryCreatedEvent)this.cl.getEvents().get(0)).getValue() == null);
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_CREATED);
        assert (((CacheEntryCreatedEvent)this.cl.getEvents().get(1)).getKey().equals("accept"));
        assert (((CacheEntryCreatedEvent)this.cl.getEvents().get(1)).getValue().equals("v1"));
    }

    private static class MockCDL
    implements ClusteringDependentLogic {
        private static final TestAddress PRIMARY = new TestAddress(0);
        private static final TestAddress BACKUP = new TestAddress(1);
        private static final TestAddress NON_OWNER = new TestAddress(2);
        boolean isOwner;
        boolean isPrimaryOwner;

        private MockCDL() {
        }

        public LocalizedCacheTopology getCacheTopology() {
            List<Address> members = Arrays.asList(PRIMARY, BACKUP, NON_OWNER);
            List[] ownership = new List[]{Arrays.asList(PRIMARY, BACKUP)};
            DefaultConsistentHash ch = new DefaultConsistentHash(2, 1, members, null, ownership);
            CacheTopology cacheTopology = new CacheTopology(0, 0, (ConsistentHash)ch, null, CacheTopology.Phase.NO_REBALANCE, null, null);
            TestAddress localAddress = this.isPrimaryOwner ? PRIMARY : (this.isOwner ? BACKUP : NON_OWNER);
            return new LocalizedCacheTopology(CacheMode.DIST_SYNC, cacheTopology, key -> 0, (Address)localAddress, true);
        }

        public CompletionStage<Void> commitEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            throw new UnsupportedOperationException();
        }

        public ClusteringDependentLogic.Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return this.isOwner ? ClusteringDependentLogic.Commit.COMMIT_LOCAL : ClusteringDependentLogic.Commit.NO_COMMIT;
        }

        public CompletionStage<Map<Object, IncrementableEntryVersion>> createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            throw new UnsupportedOperationException();
        }

        public Address getAddress() {
            throw new UnsupportedOperationException();
        }

        public <K, V> EntryLoader<K, V> getEntryLoader() {
            throw new UnsupportedOperationException();
        }

        public void start() {
        }
    }
}

