/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.TimeoutException;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.concurrent.locks.impl.PerKeyLockContainer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.SimpleLockContainerTest")
public class SimpleLockContainerTest
extends AbstractInfinispanTest {
    private final ExecutorService executor = new WithinThreadExecutor();
    PerKeyLockContainer lc = new PerKeyLockContainer();

    public void simpleTest() throws Exception {
        TestingUtil.inject(this.lc, AbstractCacheTest.TIME_SERVICE);
        String k1 = this.ab();
        final String k2 = this.ab2();
        assert (k1 != k2 && k1.equals(k2));
        Object owner = new Object();
        this.lc.acquire((Object)k1, owner, 0L, TimeUnit.MILLISECONDS).lock();
        assert (this.lc.getLock((Object)k1).isLocked());
        Future<Void> f = this.fork(new Callable<Void>(){
            final /* synthetic */ SimpleLockContainerTest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void call() throws InterruptedException, TimeoutException {
                Object otherOwner = new Object();
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.this$0.lc.acquire((Object)k2, otherOwner, 500L, TimeUnit.MILLISECONDS).lock();
                        return null;
                    }
                    catch (TimeoutException timeoutException) {
                        continue;
                    }
                }
                throw new TimeoutException("We should have acquired lock!");
            }
        });
        Thread.sleep(200L);
        this.lc.release((Object)k1, owner);
        f.get(10L, TimeUnit.SECONDS);
    }

    private String ab2() {
        return "ab";
    }

    public String ab() {
        StringBuilder sb = new StringBuilder("a");
        return sb.append("b").toString();
    }
}

