/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="distribution.TriangleOrderManagerTest")
public class TriangleOrderManagerTest
extends AbstractInfinispanTest {
    private static final Address LOCAL_ADDRESS = new TestAddress(0, "A");

    private static LocalizedCacheTopology mockCacheTopology(int topologyId) {
        List<Address> members = Collections.singletonList(LOCAL_ADDRESS);
        ReplicatedConsistentHash ch = new ReplicatedConsistentHash(members, new int[]{0});
        CacheTopology cacheTopology = new CacheTopology(topologyId, 0, (ConsistentHash)ch, null, CacheTopology.Phase.NO_REBALANCE, members, null);
        return new LocalizedCacheTopology(CacheMode.DIST_SYNC, cacheTopology, key -> 0, LOCAL_ADDRESS, true);
    }

    public void testInvalidTopologyId() {
        TriangleOrderManager triangleOrderManager = new TriangleOrderManager(4);
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(1));
        TestingUtil.inject(triangleOrderManager, mockDistributionManager);
        try {
            triangleOrderManager.next(0, 0);
            AssertJUnit.fail((String)"Exception expected!");
        }
        catch (OutdatedTopologyException e) {
            Exceptions.assertException(OutdatedTopologyException.class, (Throwable)e);
        }
        try {
            triangleOrderManager.next(1, 2);
            AssertJUnit.fail((String)"Exception expected!");
        }
        catch (OutdatedTopologyException e) {
            Exceptions.assertException(OutdatedTopologyException.class, (Throwable)e);
        }
    }

    public void testSequence() {
        TriangleOrderManager triangleOrderManager = new TriangleOrderManager(4);
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(0));
        TestingUtil.inject(triangleOrderManager, mockDistributionManager);
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(0, 0));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(1, 0));
        AssertJUnit.assertEquals((long)2L, (long)triangleOrderManager.next(1, 0));
    }

    public void testSequenceWithTopologyChange() {
        int topologyId = 1;
        TriangleOrderManager triangleOrderManager = new TriangleOrderManager(5);
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(topologyId));
        TestingUtil.inject(triangleOrderManager, mockDistributionManager);
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(1, topologyId));
        AssertJUnit.assertEquals((long)2L, (long)triangleOrderManager.next(1, topologyId));
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(++topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(1, topologyId));
        AssertJUnit.assertEquals((long)2L, (long)triangleOrderManager.next(1, topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(4, topologyId));
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(++topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(1, topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(2, topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(3, topologyId));
        AssertJUnit.assertEquals((long)1L, (long)triangleOrderManager.next(4, topologyId));
    }

    public void testDeliverOrder() {
        TriangleOrderManager triangleOrderManager = new TriangleOrderManager(4);
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).then(i -> TriangleOrderManagerTest.mockCacheTopology(0));
        TestingUtil.inject(triangleOrderManager, mockDistributionManager);
        AssertJUnit.assertTrue((boolean)triangleOrderManager.isNext(1, 1L, 0));
        AssertJUnit.assertFalse((boolean)triangleOrderManager.isNext(1, 2L, 0));
        AssertJUnit.assertFalse((boolean)triangleOrderManager.isNext(1, 3L, 0));
        triangleOrderManager.markDelivered(1, 1L, 0);
        AssertJUnit.assertTrue((boolean)triangleOrderManager.isNext(1, 2L, 0));
        AssertJUnit.assertFalse((boolean)triangleOrderManager.isNext(1, 3L, 0));
        triangleOrderManager.markDelivered(1, 2L, 0);
        AssertJUnit.assertTrue((boolean)triangleOrderManager.isNext(1, 3L, 0));
        triangleOrderManager.markDelivered(1, 3L, 0);
        triangleOrderManager.markDelivered(2, 1L, 0);
        triangleOrderManager.markDelivered(3, 1L, 0);
        triangleOrderManager.markDelivered(3, 2L, 0);
    }

    public void testUnblockOldTopology() {
        TriangleOrderManager triangleOrderManager = new TriangleOrderManager(4);
        DistributionManager mockDistributionManager = (DistributionManager)Mockito.mock(DistributionManager.class);
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(1));
        TestingUtil.inject(triangleOrderManager, mockDistributionManager);
        AssertJUnit.assertFalse((boolean)triangleOrderManager.isNext(0, 2L, 1));
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(2));
        AssertJUnit.assertTrue((boolean)triangleOrderManager.isNext(0, 2L, 1));
        AssertJUnit.assertFalse((boolean)triangleOrderManager.isNext(0, 1L, 3));
        Mockito.when((Object)mockDistributionManager.getCacheTopology()).thenReturn((Object)TriangleOrderManagerTest.mockCacheTopology(3));
        AssertJUnit.assertTrue((boolean)triangleOrderManager.isNext(0, 1L, 3));
    }
}

