/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.stream.IntStream;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="container.versioning.TopologyIracVersionUnitTest")
public class TopologyIracVersionUnitTest
extends AbstractInfinispanTest {
    public void testNoVersionInstance() {
        AssertJUnit.assertSame((Object)TopologyIracVersion.NO_VERSION, (Object)TopologyIracVersion.create((int)0, (long)0L));
    }

    public void testIncrement() {
        TopologyIracVersion vBase = TopologyIracVersion.create((int)10, (long)1L);
        AssertJUnit.assertEquals((Object)vBase.increment(5), (Object)TopologyIracVersion.create((int)10, (long)2L));
        AssertJUnit.assertEquals((Object)vBase.increment(10), (Object)TopologyIracVersion.create((int)10, (long)2L));
        AssertJUnit.assertEquals((Object)vBase.increment(15), (Object)TopologyIracVersion.create((int)15, (long)1L));
    }

    public void testNoVersionIncrement() {
        AssertJUnit.assertEquals((Object)TopologyIracVersion.NO_VERSION.increment(2), (Object)TopologyIracVersion.create((int)2, (long)1L));
    }

    public void testCompare() {
        TopologyIracVersion vBase = TopologyIracVersion.create((int)5, (long)5L);
        IntStream.range(4, 7).forEach(value -> TopologyIracVersionUnitTest.assertCompare(vBase, TopologyIracVersion.create((int)4, (long)value), 1));
        TopologyIracVersionUnitTest.assertCompare(vBase, TopologyIracVersion.create((int)5, (long)4L), 1);
        TopologyIracVersionUnitTest.assertCompareEquals(vBase, TopologyIracVersion.create((int)5, (long)5L));
        TopologyIracVersionUnitTest.assertCompare(vBase, TopologyIracVersion.create((int)5, (long)6L), -1);
        IntStream.range(4, 7).forEach(value -> TopologyIracVersionUnitTest.assertCompare(vBase, TopologyIracVersion.create((int)6, (long)value), -1));
    }

    public void testMax() {
        TopologyIracVersion vBase = TopologyIracVersion.create((int)5, (long)5L);
        IntStream.range(4, 7).forEach(value -> TopologyIracVersionUnitTest.assertMax(vBase, TopologyIracVersion.create((int)4, (long)value), true));
        TopologyIracVersionUnitTest.assertMax(vBase, TopologyIracVersion.create((int)5, (long)4L), true);
        TopologyIracVersionUnitTest.assertMax(vBase, TopologyIracVersion.create((int)5, (long)5L), true);
        TopologyIracVersionUnitTest.assertMax(vBase, TopologyIracVersion.create((int)5, (long)6L), false);
        IntStream.range(4, 7).forEach(value -> TopologyIracVersionUnitTest.assertMax(vBase, TopologyIracVersion.create((int)6, (long)value), false));
    }

    private static void assertCompare(TopologyIracVersion v1, TopologyIracVersion v2, int result) {
        AssertJUnit.assertEquals((int)result, (int)Integer.signum(v1.compareTo(v2)));
        AssertJUnit.assertEquals((int)(result * -1), (int)Integer.signum(v2.compareTo(v1)));
        Assert.assertNotEquals((Object)v1, (Object)v2);
        Assert.assertNotEquals((Object)v2, (Object)v1);
    }

    private static void assertCompareEquals(TopologyIracVersion v1, TopologyIracVersion v2) {
        AssertJUnit.assertEquals((int)0, (int)v1.compareTo(v2));
        AssertJUnit.assertEquals((int)0, (int)v2.compareTo(v1));
        AssertJUnit.assertEquals((Object)v1, (Object)v2);
        AssertJUnit.assertEquals((Object)v2, (Object)v1);
    }

    private static void assertMax(TopologyIracVersion v1, TopologyIracVersion v2, boolean expectsV1) {
        AssertJUnit.assertEquals((Object)(expectsV1 ? v1 : v2), (Object)TopologyIracVersion.max((TopologyIracVersion)v1, (TopologyIracVersion)v2));
        AssertJUnit.assertEquals((Object)(expectsV1 ? v1 : v2), (Object)TopologyIracVersion.max((TopologyIracVersion)v2, (TopologyIracVersion)v1));
    }
}

