/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.file;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.PersistenceMockUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.file.BoundedSingleFileStoreTest")
public class BoundedSingleFileStoreTest
extends AbstractInfinispanTest {
    SingleFileStore<Object, Object> store;
    String tmpDirectory;
    private TestObjectStreamMarshaller marshaller;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
    }

    @AfterClass
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.clearTempDir();
        this.store = new SingleFileStore();
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((SingleFileStoreConfigurationBuilder)((SingleFileStoreConfigurationBuilder)builder.persistence().addStore(SingleFileStoreConfigurationBuilder.class)).location(this.tmpDirectory).segmented(false)).maxEntries(1);
        this.marshaller = new TestObjectStreamMarshaller();
        CompletionStages.join((CompletionStage)this.store.start(PersistenceMockUtil.createContext(this.getClass(), builder.build(), this.marshaller)));
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        try {
            if (this.store != null) {
                this.store.clear();
                this.store.stop();
            }
            this.marshaller.stop();
        }
        finally {
            this.store = null;
        }
    }

    public void testStoreSizeExceeded() {
        this.assertStoreSize(0, 0);
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        try {
            this.store.write(0, MarshalledEntryUtil.create(Integer.valueOf(1), "v1", (Marshaller)sm));
            this.store.write(0, MarshalledEntryUtil.create(Integer.valueOf(1), "v2", (Marshaller)sm));
            this.assertStoreSize(1, 1);
        }
        finally {
            sm.stop();
        }
    }

    private void assertStoreSize(int expectedEntries, int expectedFree) {
        AssertJUnit.assertEquals((String)("Entries: " + String.valueOf(this.store.getEntries())), (int)expectedEntries, (int)this.store.getEntries().size());
        AssertJUnit.assertEquals((String)("Free: " + String.valueOf(this.store.getFreeList())), (int)expectedFree, (int)this.store.getFreeList().size());
    }
}

