/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="invalidation.ClusteredCacheLoaderInvalidationTest")
public class ClusteredCacheLoaderInvalidationTest
extends MultipleCacheManagersTest {
    private static final String key = "key";
    private static final String value = "value";
    private static final String changedValue = "changed-value";
    private static final String cacheName = "inval-write-cache-store";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = ClusteredCacheLoaderInvalidationTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false);
        ((ClusterLoaderConfigurationBuilder)cb.persistence().addStore(ClusterLoaderConfigurationBuilder.class)).segmented(false);
        this.createClusteredCaches(2, cacheName, cb);
    }

    @Test
    public void testCacheLoaderBeforeAfterInvalidation() {
        AssertJUnit.assertNull((Object)this.cache(0, cacheName).get((Object)key));
        this.cache(0, cacheName).put((Object)key, (Object)value);
        AssertJUnit.assertFalse((String)"Invalidation should not contain the value in memory", (boolean)this.cache(1, cacheName).getAdvancedCache().getDataContainer().containsKey((Object)key));
        AssertJUnit.assertEquals((Object)value, (Object)this.cache(1, cacheName).get((Object)key));
        this.cache(1, cacheName).put((Object)key, (Object)changedValue);
        AssertJUnit.assertFalse((String)"Invalidation should not contain the value in memory after other node put", (boolean)this.cache(0, cacheName).getAdvancedCache().getDataContainer().containsKey((Object)key));
        AssertJUnit.assertEquals((Object)changedValue, (Object)this.cache(0, cacheName).get((Object)key));
    }
}

