/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.BaseControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "unstable"}, testName="distribution.rehash.RehashWithL1Test", description="See ISPN-7801")
public class RehashWithL1Test
extends MultipleCacheManagersTest {
    ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        MyBaseControlledConsistentHashFactory chf = new MyBaseControlledConsistentHashFactory();
        this.builder = RehashWithL1Test.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.builder.clustering().hash().numSegments(1).numOwners(1).consistentHashFactory((ConsistentHashFactory)chf);
        this.builder.clustering().l1().enable().lifespan(10L, TimeUnit.MINUTES);
        this.createClusteredCaches(3, this.builder);
    }

    public void testPutWithRehashAndCacheClear() throws Exception {
        int i;
        int opCount = 10;
        for (int i2 = 0; i2 < opCount; ++i2) {
            this.cache(1).put((Object)("k" + i2), (Object)"some data");
        }
        for (int j = 0; j < this.caches().size(); ++j) {
            log.debugf("Populating L1 on %s", (Object)this.address(j));
            for (int i3 = 0; i3 < opCount; ++i3) {
                AssertJUnit.assertEquals((String)("Wrong value for k" + i3), (Object)"some data", (Object)this.cache(j).get((Object)("k" + i3)));
            }
        }
        int killIndex = this.caches().size() - 1;
        log.debugf("Killing node %s", (Object)this.address(killIndex));
        this.killMember(killIndex);
        for (int j = 0; j < this.caches().size(); ++j) {
            log.debugf("Checking values on %s", (Object)this.address(j));
            for (i = 0; i < opCount; ++i) {
                String key = "k" + i;
                AssertJUnit.assertEquals((String)("Wrong value for key " + key), (Object)"some data", (Object)this.cache(j).get((Object)key));
            }
        }
        log.debugf("Starting a new joiner", new Object[0]);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(this.builder);
        cm.getCache();
        for (int j = 0; j < this.caches().size() - 1; ++j) {
            log.debugf("Checking values on %s", (Object)this.address(j));
            for (int i4 = 0; i4 < opCount; ++i4) {
                AssertJUnit.assertNull((String)("wrong value for k" + i4), (Object)this.cache(j).get((Object)("k" + i4)));
            }
        }
        for (i = 0; i < opCount; ++i) {
            this.cache(0).remove((Object)("k" + i));
        }
        for (i = 0; i < opCount; ++i) {
            String key = "k" + i;
            AssertJUnit.assertFalse((boolean)this.cache(0).containsKey((Object)key));
            AssertJUnit.assertFalse((String)("Key: " + key + " is present in cache at " + String.valueOf(this.cache(0))), (boolean)this.cache(0).containsKey((Object)key));
            AssertJUnit.assertFalse((String)("Key: " + key + " is present in cache at " + String.valueOf(this.cache(1))), (boolean)this.cache(1).containsKey((Object)key));
            AssertJUnit.assertFalse((String)("Key: " + key + " is present in cache at " + String.valueOf(this.cache(2))), (boolean)this.cache(2).containsKey((Object)key));
        }
        AssertJUnit.assertEquals((int)0, (int)this.cache(0).size());
        AssertJUnit.assertEquals((int)0, (int)this.cache(1).size());
        AssertJUnit.assertEquals((int)0, (int)this.cache(2).size());
    }

    @SerializeWith(value=Ext.class)
    private static class MyBaseControlledConsistentHashFactory
    extends BaseControlledConsistentHashFactory<DefaultConsistentHash> {
        public MyBaseControlledConsistentHashFactory() {
            super(new BaseControlledConsistentHashFactory.DefaultTrait(), 1);
        }

        @Override
        protected int[][] assignOwners(int numSegments, List<Address> members) {
            return new int[][]{{members.size() - 1}};
        }

        public static final class Ext
        implements Externalizer<MyBaseControlledConsistentHashFactory> {
            public void writeObject(ObjectOutput output, MyBaseControlledConsistentHashFactory object) {
            }

            public MyBaseControlledConsistentHashFactory readObject(ObjectInput input) {
                return new MyBaseControlledConsistentHashFactory();
            }
        }
    }
}

