/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="distribution.rehash.RehashAfterJoinWithPreloadTest", groups={"functional"})
public class RehashAfterJoinWithPreloadTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(RehashAfterJoinWithPreloadTest.class);
    public static final int NUM_KEYS = 20;
    private final String testCacheName = "testCache" + this.getClass().getSimpleName();

    @Override
    protected void createCacheManagers() {
    }

    private void addNewCacheManagerAndWaitForRehash() {
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(RehashAfterJoinWithPreloadTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false));
        cacheManager.defineConfiguration(this.testCacheName, this.buildCfg(true));
        log.debugf("\n\nstarted CacheManager #%d", this.getCacheManagers().size() - 1);
        this.waitForClusterToForm(this.testCacheName);
    }

    private Configuration buildCfg(boolean clustered) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cb.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.testCacheName).preload(true)).shared(true)).purgeOnStartup(false);
        cb.persistence().passivation(false);
        if (clustered) {
            cb.clustering().l1().disable();
            cb.clustering().cacheMode(CacheMode.DIST_SYNC);
            cb.clustering().hash().numOwners(1);
            cb.clustering().stateTransfer().fetchInMemoryState(true);
            cb.clustering().hash().groups().enabled();
        }
        return cb.build(true);
    }

    public void test() {
        this.addNewCacheManagerAndWaitForRehash();
        this.putTestDataInCacheStore();
        this.printCacheContents();
        this.killMember(0);
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.assertEvenDistribution();
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.assertEvenDistribution();
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.assertEvenDistribution();
    }

    private void assertEvenDistribution() {
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            Cache testCache = this.manager(i).getCache(this.testCacheName);
            DistributionManager dm = testCache.getAdvancedCache().getDistributionManager();
            DataContainer dataContainer = testCache.getAdvancedCache().getDataContainer();
            for (int j = 0; j < 20; ++j) {
                String key = "key" + j;
                if (dm.getCacheTopology().isReadOwner((Object)key)) {
                    AssertJUnit.assertTrue((String)("Key '" + key + "' is owned by node " + String.valueOf(this.address(i)) + " but it doesn't appear there"), (boolean)dataContainer.containsKey((Object)key));
                    continue;
                }
                AssertJUnit.assertTrue((String)("Key '" + key + "' is not owned by node " + String.valueOf(this.address(i)) + " but it still appears there"), (!dataContainer.containsKey((Object)key) ? 1 : 0) != 0);
            }
        }
    }

    private void putTestDataInCacheStore() {
        Cache cache = this.manager(0).getCache(this.testCacheName);
        for (int i = 0; i < 20; ++i) {
            cache.put((Object)("key" + i), (Object)Integer.toString(i));
        }
        log.debugf("added %d entries to test cache", 20);
    }

    private void printCacheContents() {
        log.debugf("%d cache manager(s)", this.getCacheManagers().size());
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            Cache testCache = this.manager(i).getCache(this.testCacheName);
            log.debugf(" Contents of Cache with CacheManager #%d (%s, all members: %s)", i, (Object)this.address(i), (Object)testCache.getAdvancedCache().getRpcManager().getMembers());
            CacheSet keySet = testCache.keySet();
            log.debugf(" keySet = %s", (Object)keySet);
            for (String key : keySet) {
                log.debugf("  key: %s  value: %s", (Object)key, testCache.get((Object)key));
            }
        }
    }
}

